/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.device.reader.pii;

import com.unity3d.services.core.device.reader.pii.NonBehavioralFlag;
import com.unity3d.services.core.device.reader.pii.NonBehavioralFlagReader;
import com.unity3d.services.core.device.reader.pii.PiiPrivacyMode;
import com.unity3d.services.core.misc.IJsonStorageReader;

public class PiiTrackingStatusReader {
    private final IJsonStorageReader _jsonStorageReader;
    private final NonBehavioralFlagReader _nonBehavioralFlagReader;

    public PiiTrackingStatusReader(IJsonStorageReader jsonStorageReader) {
        this._jsonStorageReader = jsonStorageReader;
        this._nonBehavioralFlagReader = new NonBehavioralFlagReader(jsonStorageReader);
    }

    public PiiPrivacyMode getPrivacyMode() {
        if (this.getUserPrivacyMode() == PiiPrivacyMode.NULL && this.getSpmPrivacyMode() == PiiPrivacyMode.NULL) {
            return PiiPrivacyMode.NULL;
        }
        if (this.getUserPrivacyMode() == PiiPrivacyMode.APP || this.getSpmPrivacyMode() == PiiPrivacyMode.APP) {
            return PiiPrivacyMode.APP;
        }
        if (this.getUserPrivacyMode() == PiiPrivacyMode.MIXED || this.getSpmPrivacyMode() == PiiPrivacyMode.MIXED) {
            return PiiPrivacyMode.MIXED;
        }
        if (this.getUserPrivacyMode() == PiiPrivacyMode.NONE || this.getSpmPrivacyMode() == PiiPrivacyMode.NONE) {
            return PiiPrivacyMode.NONE;
        }
        return PiiPrivacyMode.UNDEFINED;
    }

    public boolean getUserNonBehavioralFlag() {
        return this._nonBehavioralFlagReader.getUserNonBehavioralFlag() == NonBehavioralFlag.TRUE;
    }

    private PiiPrivacyMode getUserPrivacyMode() {
        return this.getPrivacyMode("privacy.mode.value");
    }

    private PiiPrivacyMode getSpmPrivacyMode() {
        return this.getPrivacyMode("privacy.spm.value");
    }

    private PiiPrivacyMode getPrivacyMode(String storageKey) {
        Object privacyModeObj;
        String privacyMode = null;
        if (this._jsonStorageReader != null && (privacyModeObj = this._jsonStorageReader.get(storageKey)) instanceof String) {
            privacyMode = (String)privacyModeObj;
        }
        return PiiPrivacyMode.getPiiPrivacyMode(privacyMode);
    }
}

