/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ads.gmascar.managers;

import com.unity3d.ads.IUnityAdsTokenListener;
import com.unity3d.services.ads.gmascar.GMA;
import com.unity3d.services.ads.gmascar.managers.BiddingBaseManager;
import com.unity3d.services.ads.gmascar.managers.BiddingDisabledManager;
import com.unity3d.services.ads.gmascar.managers.BiddingEagerManager;
import com.unity3d.services.ads.gmascar.managers.ScarBiddingManagerType;
import com.unity3d.services.core.configuration.IExperiments;

public class BiddingManagerFactory {
    private static BiddingManagerFactory instance;

    private BiddingManagerFactory() {
    }

    public static BiddingManagerFactory getInstance() {
        if (instance == null) {
            instance = new BiddingManagerFactory();
        }
        return instance;
    }

    public BiddingBaseManager createManager(IUnityAdsTokenListener unityAdsTokenListener, IExperiments experiments) {
        if (GMA.getInstance().hasSCARBiddingSupport()) {
            return this.getExperiment(unityAdsTokenListener, experiments);
        }
        return new BiddingDisabledManager(unityAdsTokenListener);
    }

    private BiddingBaseManager getExperiment(IUnityAdsTokenListener unityAdsTokenListener, IExperiments experiments) {
        if (experiments == null || experiments.getScarBiddingManager() == null) {
            return new BiddingDisabledManager(unityAdsTokenListener);
        }
        String biddingManager = experiments.getScarBiddingManager();
        ScarBiddingManagerType biddingManagerType = ScarBiddingManagerType.fromName(biddingManager);
        switch (biddingManagerType) {
            case EAGER: {
                return new BiddingEagerManager(experiments.isScarBannerHbEnabled(), unityAdsTokenListener);
            }
        }
        return new BiddingDisabledManager(unityAdsTokenListener);
    }
}

