package com.unity3d.ads.core.domain.work

import android.content.Context
import androidx.work.WorkerParameters
import com.unity3d.ads.core.domain.GetRequestPolicy
import com.unity3d.services.core.di.IServiceComponent
import com.unity3d.services.core.di.ServiceProvider
import com.unity3d.services.core.di.inject

class OperativeEventJob(
    context: Context,
    workerParams: WorkerParameters
) : UniversalRequestJob(context, workerParams), IServiceComponent {

    private val getOperativeRequestPolicy: GetRequestPolicy by inject(ServiceProvider.NAMED_OPERATIVE_REQ)

    override suspend fun doWork(): Result {
        requestPolicy = getOperativeRequestPolicy()
        return super.doWork()
    }
}