package com.unity3d.ads.core.domain.events

import com.unity3d.ads.core.data.repository.DeviceInfoRepository
import gatewayprotocol.v1.TransactionEventRequestOuterClass
import gatewayprotocol.v1.transactionEventRequest



internal class GetCommonTransactionRequest(
    private val deviceInfoRepository: DeviceInfoRepository
): GetTransactionRequest {
    override suspend operator fun invoke(transactionDataList: List<TransactionEventRequestOuterClass.TransactionData>): TransactionEventRequestOuterClass.TransactionEventRequest {
        return transactionEventRequest {
            staticDeviceInfo = deviceInfoRepository.staticDeviceInfo()
            dynamicDeviceInfo = deviceInfoRepository.dynamicDeviceInfo
            appStore = TransactionEventRequestOuterClass.StoreType.STORE_TYPE_GOOGLE_PLAY
            transactionData.addAll(
                transactionDataList
            )
        }
    }
}