package com.unity3d.ads.core.domain

import com.google.protobuf.ByteString
import com.unity3d.ads.core.data.repository.CampaignRepository
import com.unity3d.ads.core.data.repository.DeviceInfoRepository
import com.unity3d.ads.core.data.repository.SessionRepository
import gatewayprotocol.v1.UniversalRequestKt
import gatewayprotocol.v1.UniversalRequestOuterClass.UniversalRequest
import gatewayprotocol.v1.adDataRefreshRequest



internal class GetAndroidAdDataRefreshRequest(
    private val getUniversalRequestForPayLoad: GetUniversalRequestForPayLoad,
    private val sessionRepository: SessionRepository,
    private val deviceInfoRepository: DeviceInfoRepository,
    private val campaignRepository: CampaignRepository,
) : GetAdDataRefreshRequest {
    override suspend fun invoke(
        opportunityId: ByteString,
        refreshToken: ByteString
    ): UniversalRequest {
        val request = adDataRefreshRequest {
            sessionCounters = sessionRepository.sessionCounters
            staticDeviceInfo = deviceInfoRepository.staticDeviceInfo()
            dynamicDeviceInfo = deviceInfoRepository.dynamicDeviceInfo
            impressionOpportunityId = opportunityId
            campaignState = campaignRepository.getCampaignState()
            if (!refreshToken.isEmpty) adDataRefreshToken = refreshToken
        }
        val payload = UniversalRequestKt.payload {
            adDataRefreshRequest = request
        }
        return getUniversalRequestForPayLoad(payload)
    }
}