package com.unity3d.ads.core.domain

import com.unity3d.ads.core.data.repository.CampaignRepository
import com.unity3d.ads.core.data.repository.DeviceInfoRepository
import com.unity3d.ads.core.data.repository.SessionRepository
import com.unity3d.ads.core.data.repository.TcfRepository
import com.unity3d.ads.core.extensions.toBase64
import com.unity3d.ads.core.extensions.toISO8859ByteString
import gatewayprotocol.v1.headerBiddingToken

internal class CommonGetHeaderBiddingToken(
    private val generateId: GetByteStringId,
    private val getClientInfo: GetClientInfo,
    private val getTimestamps: GetSharedDataTimestamps,
    private val deviceInfoRepository: DeviceInfoRepository,
    private val sessionRepository: SessionRepository,
    private val campaignRepository: CampaignRepository,
    private val tcfRepository: TcfRepository
) : GetHeaderBiddingToken {
    override fun invoke(): String {
        val rawToken = headerBiddingToken {
            tokenId = generateId()
            tokenNumber = sessionRepository.headerBiddingTokenCounter
            sessionToken = sessionRepository.sessionToken
            clientInfo = getClientInfo()
            timestamps = getTimestamps()
            sessionCounters = sessionRepository.sessionCounters
            staticDeviceInfo = deviceInfoRepository.cachedStaticDeviceInfo()
            dynamicDeviceInfo = deviceInfoRepository.dynamicDeviceInfo
            val piiData = deviceInfoRepository.piiData
            if (!piiData.advertisingId.isEmpty || !piiData.openAdvertisingTrackingId.isEmpty) pii = piiData
            campaignState = campaignRepository.getCampaignState()
            tcfRepository.tcfString?.let { tcf = it.toISO8859ByteString() }
        }
        // mediation receives a base64 encoded string
        val token = rawToken.toByteString().toBase64()
        // append version
        return "$HB_TOKEN_VERSION:$token"
    }

    companion object {
        const val HB_TOKEN_VERSION = "2"
    }
}