package com.unity3d.services.core.di

import ByteStringStoreOuterClass.ByteStringStore
import UniversalRequestStoreOuterClass
import WebviewConfigurationStore
import android.content.Context
import android.os.Handler
import android.os.Looper
import androidx.datastore.core.DataMigration
import androidx.datastore.core.DataStore
import androidx.datastore.core.DataStoreFactory
import androidx.datastore.dataStoreFile
import com.google.android.gms.net.CronetProviderInstaller
import com.unity3d.ads.core.configuration.AlternativeFlowReader
import com.unity3d.ads.core.configuration.GameServerIdReader
import com.unity3d.ads.core.data.datasource.AnalyticsDataSource
import com.unity3d.ads.core.data.datasource.AndroidByteStringDataSource
import com.unity3d.ads.core.data.datasource.AndroidDeveloperConsentDataSource
import com.unity3d.ads.core.data.datasource.AndroidDynamicDeviceInfoDataSource
import com.unity3d.ads.core.data.datasource.AndroidLegacyUserConsentDataSource
import com.unity3d.ads.core.data.datasource.AndroidLifecycleDataSource
import com.unity3d.ads.core.data.datasource.AndroidLocalCacheDataSource
import com.unity3d.ads.core.data.datasource.AndroidMediationDataSource
import com.unity3d.ads.core.data.datasource.AndroidPrivacyDeviceInfoDataSource
import com.unity3d.ads.core.data.datasource.AndroidRemoteCacheDataSource
import com.unity3d.ads.core.data.datasource.AndroidStaticDeviceInfoDataSource
import com.unity3d.ads.core.data.datasource.ByteStringDataSource
import com.unity3d.ads.core.data.datasource.CacheDataSource
import com.unity3d.ads.core.data.datasource.DeveloperConsentDataSource
import com.unity3d.ads.core.data.datasource.DynamicDeviceInfoDataSource
import com.unity3d.ads.core.data.datasource.FetchGLInfoDataMigration
import com.unity3d.ads.core.data.datasource.ForcefulPreservingByteStringPreferenceMigration
import com.unity3d.ads.core.data.datasource.LegacyUserConsentDataSource
import com.unity3d.ads.core.data.datasource.LifecycleDataSource
import com.unity3d.ads.core.data.datasource.MediationDataSource
import com.unity3d.ads.core.data.datasource.PreservingByteStringPreferenceMigration
import com.unity3d.ads.core.data.datasource.PrivacyDeviceInfoDataSource
import com.unity3d.ads.core.data.datasource.StaticDeviceInfoDataSource
import com.unity3d.ads.core.data.datasource.UniversalRequestDataSource
import com.unity3d.ads.core.data.datasource.WebviewConfigurationDataSource
import com.unity3d.ads.core.data.manager.AndroidOmidManager
import com.unity3d.ads.core.data.manager.AndroidSDKPropertiesManager
import com.unity3d.ads.core.data.manager.AndroidStorageManager
import com.unity3d.ads.core.data.manager.OmidManager
import com.unity3d.ads.core.data.manager.SDKPropertiesManager
import com.unity3d.ads.core.data.manager.TransactionEventManager
import com.unity3d.ads.core.data.model.ByteStringSerializer
import com.unity3d.ads.core.data.model.UniversalRequestStoreSerializer
import com.unity3d.ads.core.data.model.WebViewConfigurationStoreSerializer
import com.unity3d.ads.core.data.repository.AdRepository
import com.unity3d.ads.core.data.repository.AndroidAdRepository
import com.unity3d.ads.core.data.repository.AndroidCacheRepository
import com.unity3d.ads.core.data.repository.AndroidCampaignRepository
import com.unity3d.ads.core.data.repository.AndroidDeveloperConsentRepository
import com.unity3d.ads.core.data.repository.AndroidDeviceInfoRepository
import com.unity3d.ads.core.data.repository.AndroidDiagnosticEventRepository
import com.unity3d.ads.core.data.repository.AndroidLegacyUserConsentRepository
import com.unity3d.ads.core.data.repository.AndroidMediationRepository
import com.unity3d.ads.core.data.repository.AndroidOpenMeasurementRepository
import com.unity3d.ads.core.data.repository.AndroidSessionRepository
import com.unity3d.ads.core.data.repository.AndroidTransactionEventRepository
import com.unity3d.ads.core.data.repository.CacheRepository
import com.unity3d.ads.core.data.repository.CampaignRepository
import com.unity3d.ads.core.data.repository.DeveloperConsentRepository
import com.unity3d.ads.core.data.repository.DeviceInfoRepository
import com.unity3d.ads.core.data.repository.DiagnosticEventRepository
import com.unity3d.ads.core.data.repository.LegacyUserConsentRepository
import com.unity3d.ads.core.data.repository.MediationRepository
import com.unity3d.ads.core.data.repository.OpenMeasurementRepository
import com.unity3d.ads.core.data.repository.OperativeEventRepository
import com.unity3d.ads.core.data.repository.SessionRepository
import com.unity3d.ads.core.data.repository.TransactionEventRepository
import com.unity3d.ads.core.domain.AndroidBoldExperimentHandler
import com.unity3d.ads.core.domain.AndroidExecuteAdViewerRequest
import com.unity3d.ads.core.domain.AndroidGenerateByteStringId
import com.unity3d.ads.core.domain.AndroidGetWebViewContainerUseCase
import com.unity3d.ads.core.domain.AndroidHandleOpenUrl
import com.unity3d.ads.core.domain.AndroidLoad
import com.unity3d.ads.core.domain.AndroidRefresh
import com.unity3d.ads.core.domain.AndroidSendDiagnosticEvent
import com.unity3d.ads.core.domain.AndroidSendWebViewClientErrorDiagnostics
import com.unity3d.ads.core.domain.AndroidShow
import com.unity3d.ads.core.domain.AwaitInitialization
import com.unity3d.ads.core.domain.BoldExperimentHandler
import com.unity3d.ads.core.domain.CacheFile
import com.unity3d.ads.core.domain.ClearCache
import com.unity3d.ads.core.domain.CommonAwaitInitialization
import com.unity3d.ads.core.domain.CommonCacheFile
import com.unity3d.ads.core.domain.CommonClearCache
import com.unity3d.ads.core.domain.CommonGetAdObject
import com.unity3d.ads.core.domain.CommonGetHeaderBiddingToken
import com.unity3d.ads.core.domain.CommonGetInitializationState
import com.unity3d.ads.core.domain.CommonGetIsFileCache
import com.unity3d.ads.core.domain.CommonInitAwaitingGetHeaderBiddingToken
import com.unity3d.ads.core.domain.CommonSetInitializationState
import com.unity3d.ads.core.domain.ExecuteAdViewerRequest
import com.unity3d.ads.core.domain.GetAdDataRefreshRequest
import com.unity3d.ads.core.domain.GetAdObject
import com.unity3d.ads.core.domain.GetAdPlayerConfigRequest
import com.unity3d.ads.core.domain.GetAdRequest
import com.unity3d.ads.core.domain.GetAdRequestPolicy
import com.unity3d.ads.core.domain.GetAndroidAdDataRefreshRequest
import com.unity3d.ads.core.domain.GetAndroidAdPlayerConfigRequest
import com.unity3d.ads.core.domain.GetAndroidAdPlayerContext
import com.unity3d.ads.core.domain.GetAndroidAdRequest
import com.unity3d.ads.core.domain.GetAndroidClientInfo
import com.unity3d.ads.core.domain.GetAndroidInitializationCompletedRequest
import com.unity3d.ads.core.domain.GetAndroidInitializationRequest
import com.unity3d.ads.core.domain.GetAndroidLimitedSessionToken
import com.unity3d.ads.core.domain.GetAndroidOpenGLRendererInfo
import com.unity3d.ads.core.domain.GetAndroidSharedDataTimestamps
import com.unity3d.ads.core.domain.GetAndroidUniversalRequestForPayLoad
import com.unity3d.ads.core.domain.GetAndroidUniversalRequestSharedData
import com.unity3d.ads.core.domain.GetAsyncHeaderBiddingToken
import com.unity3d.ads.core.domain.GetByteStringId
import com.unity3d.ads.core.domain.GetCachedAsset
import com.unity3d.ads.core.domain.GetClientInfo
import com.unity3d.ads.core.domain.GetCommonWebViewBridgeUseCase
import com.unity3d.ads.core.domain.GetHeaderBiddingToken
import com.unity3d.ads.core.domain.GetInitRequestPolicy
import com.unity3d.ads.core.domain.GetInitializationCompletedRequest
import com.unity3d.ads.core.domain.GetInitializationRequest
import com.unity3d.ads.core.domain.GetInitializationState
import com.unity3d.ads.core.domain.GetIsFileCache
import com.unity3d.ads.core.domain.GetLatestWebViewConfiguration
import com.unity3d.ads.core.domain.GetLimitedSessionToken
import com.unity3d.ads.core.domain.GetOpenGLRendererInfo
import com.unity3d.ads.core.domain.GetOperativeEventRequestPolicy
import com.unity3d.ads.core.domain.GetOtherRequestPolicy
import com.unity3d.ads.core.domain.GetPrivacyUpdateRequest
import com.unity3d.ads.core.domain.GetRequestPolicy
import com.unity3d.ads.core.domain.GetSharedDataTimestamps
import com.unity3d.ads.core.domain.GetUniversalRequestForPayLoad
import com.unity3d.ads.core.domain.GetUniversalRequestSharedData
import com.unity3d.ads.core.domain.GetWebViewBridgeUseCase
import com.unity3d.ads.core.domain.GetWebViewContainerUseCase
import com.unity3d.ads.core.domain.HandleAndroidGatewayInitializationResponse
import com.unity3d.ads.core.domain.HandleAndroidGatewayUniversalResponse
import com.unity3d.ads.core.domain.HandleGatewayAdResponse
import com.unity3d.ads.core.domain.HandleGatewayAndroidAdResponse
import com.unity3d.ads.core.domain.HandleGatewayInitializationResponse
import com.unity3d.ads.core.domain.HandleGatewayUniversalResponse
import com.unity3d.ads.core.domain.HandleInvocationsFromAdViewer
import com.unity3d.ads.core.domain.HandleOpenUrl
import com.unity3d.ads.core.domain.InitializeAndroidBoldSDK
import com.unity3d.ads.core.domain.InitializeBoldSDK
import com.unity3d.ads.core.domain.LegacyLoadUseCase
import com.unity3d.ads.core.domain.LegacyShowUseCase
import com.unity3d.ads.core.domain.Load
import com.unity3d.ads.core.domain.Refresh
import com.unity3d.ads.core.domain.SendDiagnosticEvent
import com.unity3d.ads.core.domain.SendDiagnosticEvent.Companion.SYSTEM_CRONET_FAILURE
import com.unity3d.ads.core.domain.SendDiagnosticEvent.Companion.SYSTEM_CRONET_SUCCESS
import com.unity3d.ads.core.domain.SendPrivacyUpdateRequest
import com.unity3d.ads.core.domain.SendWebViewClientErrorDiagnostics
import com.unity3d.ads.core.domain.SetInitializationState
import com.unity3d.ads.core.domain.TriggerAndroidInitializationCompletedRequest
import com.unity3d.ads.core.domain.TriggerInitializationCompletedRequest
import com.unity3d.ads.core.domain.TriggerInitializeListener
import com.unity3d.ads.core.domain.events.DiagnosticEventObserver
import com.unity3d.ads.core.domain.events.EventObservers
import com.unity3d.ads.core.domain.events.GetAndroidTransactionData
import com.unity3d.ads.core.domain.events.GetCommonTransactionRequest
import com.unity3d.ads.core.domain.events.GetDiagnosticEventBatchRequest
import com.unity3d.ads.core.domain.events.GetDiagnosticEventRequest
import com.unity3d.ads.core.domain.events.GetOperativeEventApi
import com.unity3d.ads.core.domain.events.GetOperativeEventRequest
import com.unity3d.ads.core.domain.events.GetTransactionData
import com.unity3d.ads.core.domain.events.GetTransactionRequest
import com.unity3d.ads.core.domain.events.HandleGatewayEventResponse
import com.unity3d.ads.core.domain.events.OperativeEventObserver
import com.unity3d.ads.core.domain.events.TransactionEventObserver
import com.unity3d.ads.core.domain.events.UniversalRequestEventSender
import com.unity3d.ads.core.domain.om.AndroidOmFinishSession
import com.unity3d.ads.core.domain.om.AndroidOmImpressionOccurred
import com.unity3d.ads.core.domain.om.AndroidOmInteraction
import com.unity3d.ads.core.domain.om.AndroidOmStartSession
import com.unity3d.ads.core.domain.om.CommonGetOmData
import com.unity3d.ads.core.domain.om.CommonIsOMActivated
import com.unity3d.ads.core.domain.om.GetOmData
import com.unity3d.ads.core.domain.om.InitializeOMAndroidSDK
import com.unity3d.ads.core.domain.om.InitializeOMSDK
import com.unity3d.ads.core.domain.om.IsOMActivated
import com.unity3d.ads.core.domain.om.OmFinishSession
import com.unity3d.ads.core.domain.om.OmImpressionOccurred
import com.unity3d.ads.core.domain.privacy.DeveloperConsentFlattenerRulesUseCase
import com.unity3d.ads.core.domain.privacy.FlattenerRulesUseCase
import com.unity3d.ads.core.domain.privacy.LegacyUserConsentFlattenerRulesUseCase
import com.unity3d.ads.core.domain.work.BackgroundWorker
import com.unity3d.ads.core.domain.work.DiagnosticEventRequestWorkModifier
import com.unity3d.ads.core.extensions.toByteString
import com.unity3d.ads.gatewayclient.CommonGatewayClient
import com.unity3d.ads.gatewayclient.GatewayClient
import com.unity3d.services.SDKErrorHandler
import com.unity3d.services.UnityAdsConstants
import com.unity3d.services.ads.measurements.MeasurementsService
import com.unity3d.services.ads.token.AsyncTokenStorage
import com.unity3d.services.ads.token.InMemoryAsyncTokenStorage
import com.unity3d.services.ads.token.InMemoryTokenStorage
import com.unity3d.services.ads.token.TokenStorage
import com.unity3d.services.ads.topics.TopicsService
import com.unity3d.services.core.configuration.ConfigurationReader
import com.unity3d.services.core.device.StorageManager
import com.unity3d.services.core.device.StorageManager.StorageType
import com.unity3d.services.core.device.VolumeChange
import com.unity3d.services.core.device.VolumeChangeContentObserver
import com.unity3d.services.core.device.VolumeChangeMonitor
import com.unity3d.services.core.di.ServiceProvider.CDN_CREATIVES_HOST
import com.unity3d.services.core.di.ServiceProvider.CDN_CREATIVES_PORT
import com.unity3d.services.core.di.ServiceProvider.DATA_STORE_GATEWAY_CACHE
import com.unity3d.services.core.di.ServiceProvider.DATA_STORE_GL_INFO
import com.unity3d.services.core.di.ServiceProvider.DATA_STORE_IAP_TRANSACTION
import com.unity3d.services.core.di.ServiceProvider.DATA_STORE_NATIVE_CONFIG
import com.unity3d.services.core.di.ServiceProvider.DATA_STORE_PRIVACY
import com.unity3d.services.core.di.ServiceProvider.DATA_STORE_PRIVACY_FSM
import com.unity3d.services.core.di.ServiceProvider.DATA_STORE_UNIVERSAL_REQUEST
import com.unity3d.services.core.di.ServiceProvider.DATA_STORE_WEBVIEW_CONFIG
import com.unity3d.services.core.di.ServiceProvider.DEFAULT_DISPATCHER
import com.unity3d.services.core.di.ServiceProvider.DEV_CONSENT_PRIVACY_RULES
import com.unity3d.services.core.di.ServiceProvider.GATEWAY_HOST
import com.unity3d.services.core.di.ServiceProvider.GATEWAY_PORT
import com.unity3d.services.core.di.ServiceProvider.HTTP_CACHE_DISK_SIZE
import com.unity3d.services.core.di.ServiceProvider.HTTP_CLIENT_FETCH_TIMEOUT
import com.unity3d.services.core.di.ServiceProvider.IO_DISPATCHER
import com.unity3d.services.core.di.ServiceProvider.LEGACY_PRIVACY_RULES
import com.unity3d.services.core.di.ServiceProvider.MAIN_DISPATCHER
import com.unity3d.services.core.di.ServiceProvider.NAMED_AD_REQ
import com.unity3d.services.core.di.ServiceProvider.NAMED_GET_TOKEN_SCOPE
import com.unity3d.services.core.di.ServiceProvider.NAMED_INIT_REQ
import com.unity3d.services.core.di.ServiceProvider.NAMED_INIT_SCOPE
import com.unity3d.services.core.di.ServiceProvider.NAMED_LOAD_SCOPE
import com.unity3d.services.core.di.ServiceProvider.NAMED_LOCAL
import com.unity3d.services.core.di.ServiceProvider.NAMED_OMID_SCOPE
import com.unity3d.services.core.di.ServiceProvider.NAMED_OPERATIVE_REQ
import com.unity3d.services.core.di.ServiceProvider.NAMED_OTHER_REQ
import com.unity3d.services.core.di.ServiceProvider.NAMED_PUBLIC_JOB
import com.unity3d.services.core.di.ServiceProvider.NAMED_REMOTE
import com.unity3d.services.core.di.ServiceProvider.NAMED_SDK
import com.unity3d.services.core.di.ServiceProvider.NAMED_SHOW_SCOPE
import com.unity3d.services.core.di.ServiceProvider.NAMED_TRANSACTION_SCOPE
import com.unity3d.services.core.di.ServiceProvider.PREF_GL_INFO
import com.unity3d.services.core.domain.ISDKDispatchers
import com.unity3d.services.core.domain.SDKDispatchers
import com.unity3d.services.core.domain.task.ConfigFileFromLocalStorage
import com.unity3d.services.core.domain.task.InitializeSDK
import com.unity3d.services.core.domain.task.InitializeStateComplete
import com.unity3d.services.core.domain.task.InitializeStateConfig
import com.unity3d.services.core.domain.task.InitializeStateConfigWithLoader
import com.unity3d.services.core.domain.task.InitializeStateCreate
import com.unity3d.services.core.domain.task.InitializeStateError
import com.unity3d.services.core.domain.task.InitializeStateLoadCache
import com.unity3d.services.core.domain.task.InitializeStateLoadWeb
import com.unity3d.services.core.domain.task.InitializeStateNetworkError
import com.unity3d.services.core.domain.task.InitializeStateReset
import com.unity3d.services.core.misc.JsonStorage
import com.unity3d.services.core.network.core.CronetClient
import com.unity3d.services.core.network.core.HttpClient
import com.unity3d.services.core.network.core.LegacyHttpClient
import com.unity3d.services.core.network.core.OkHttp3Client
import com.unity3d.services.core.preferences.AndroidPreferences
import com.unity3d.services.core.properties.ClientProperties
import com.unity3d.services.core.request.metrics.SDKMetrics
import com.unity3d.services.core.request.metrics.SDKMetricsSender
import com.unity3d.services.core.webview.bridge.SharedInstances
import com.unity3d.services.store.StoreMonitor
import com.unity3d.services.store.StoreWebViewEventSender
import com.unity3d.services.store.core.GatewayStoreExceptionHandler
import com.unity3d.services.store.core.StoreEventListenerFactory
import com.unity3d.services.store.core.StoreExceptionHandler
import gateway.v1.NativeConfigurationOuterClass.AdOperationsConfiguration
import gateway.v1.NativeConfigurationOuterClass.NativeConfiguration
import gateway.v1.NativeConfigurationOuterClass.RequestPolicy
import gateway.v1.NativeConfigurationOuterClass.RequestRetryPolicy
import gateway.v1.NativeConfigurationOuterClass.RequestTimeoutPolicy
import gateway.v1.adOperationsConfiguration
import gateway.v1.diagnosticEventsConfiguration
import gateway.v1.nativeConfiguration
import gateway.v1.requestPolicy
import gateway.v1.requestRetryPolicy
import gateway.v1.requestTimeoutPolicy
import kotlinx.coroutines.CoroutineDispatcher
import kotlinx.coroutines.CoroutineExceptionHandler
import kotlinx.coroutines.CoroutineName
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.Job
import kotlinx.coroutines.SupervisorJob
import kotlinx.coroutines.runBlocking
import kotlinx.coroutines.suspendCancellableCoroutine
import kotlinx.coroutines.withTimeoutOrNull
import okhttp3.OkHttpClient
import org.chromium.net.CronetEngine
import java.util.*
import kotlin.coroutines.resume
import kotlin.time.DurationUnit
import kotlin.time.ExperimentalTime
import kotlin.time.TimeSource

class UnityAdsModule {
    fun androidContext(): Context = ClientProperties.getApplicationContext()

    fun mainDispatcher(): CoroutineDispatcher = Dispatchers.Main

    fun defaultDispatcher(): CoroutineDispatcher = Dispatchers.Default

    fun ioDispatcher(): CoroutineDispatcher = Dispatchers.IO

    fun sdkDispatchers(): ISDKDispatchers = SDKDispatchers()

    fun sdkMetrics(): SDKMetricsSender = SDKMetrics.getInstance()

    fun initCoroutineScope(
        dispatchers: ISDKDispatchers,
        errorHandler: CoroutineExceptionHandler,
        parentJob: Job,
    ): CoroutineScope = CoroutineScope(parentJob + dispatchers.default + CoroutineName(NAMED_INIT_SCOPE) + errorHandler)

    fun loadCoroutineScope(
        dispatchers: ISDKDispatchers,
        errorHandler: CoroutineExceptionHandler,
        parentJob: Job,
    ): CoroutineScope = CoroutineScope(parentJob + dispatchers.default + CoroutineName(NAMED_LOAD_SCOPE) + errorHandler)

    fun showCoroutineScope(
        dispatchers: ISDKDispatchers,
        errorHandler: CoroutineExceptionHandler,
        parentJob: Job,
    ): CoroutineScope = CoroutineScope(parentJob + dispatchers.default + CoroutineName(NAMED_SHOW_SCOPE) + errorHandler)

    fun transactionCoroutineScope(
        dispatchers: ISDKDispatchers,
        errorHandler: CoroutineExceptionHandler,
        parentJob: Job,
    ): CoroutineScope =
        CoroutineScope(parentJob + dispatchers.main + CoroutineName(NAMED_TRANSACTION_SCOPE) + errorHandler)

    fun getTokenCoroutineScope(
        dispatchers: ISDKDispatchers,
        errorHandler: CoroutineExceptionHandler,
        parentJob: Job,
    ): CoroutineScope =
        CoroutineScope(parentJob + dispatchers.main + CoroutineName(NAMED_GET_TOKEN_SCOPE) + errorHandler)

    fun omidCoroutineScope(
        dispatchers: ISDKDispatchers,
        errorHandler: CoroutineExceptionHandler,
        parentJob: Job,
    ): CoroutineScope = CoroutineScope(parentJob + dispatchers.main + CoroutineName(NAMED_OMID_SCOPE) + errorHandler)

    fun publicApiJob(
        diagnosticEventRepository: DiagnosticEventRepository,
    ): Job = Job().apply {
        invokeOnCompletion {
            diagnosticEventRepository.flush()
        }
    }

    fun gatewayDataStore(
        context: Context,
        dispatcher: CoroutineDispatcher,
    ): DataStore<ByteStringStore> = provideByteStringDataStore(context, dispatcher, DATA_STORE_GATEWAY_CACHE)

    fun privacyDataStore(
        context: Context,
        dispatcher: CoroutineDispatcher,
    ): DataStore<ByteStringStore> = provideByteStringDataStore(context, dispatcher, DATA_STORE_PRIVACY)

    fun privacyFsmDataStore(
        context: Context,
        dispatcher: CoroutineDispatcher,
    ): DataStore<ByteStringStore> = provideByteStringDataStore(context, dispatcher, DATA_STORE_PRIVACY_FSM)

    fun nativeConfigurationDataStore(
        context: Context,
        dispatcher: CoroutineDispatcher,
    ): DataStore<ByteStringStore> = provideByteStringDataStore(context, dispatcher, DATA_STORE_NATIVE_CONFIG)

    fun glInfoDataStore(
        context: Context, dispatcher: CoroutineDispatcher, fetchGLInfo: DataMigration<ByteStringStore>
    ): DataStore<ByteStringStore> = DataStoreFactory.create(
        serializer = ByteStringSerializer(),
        produceFile = { context.dataStoreFile(DATA_STORE_GL_INFO) },
        migrations = listOf(fetchGLInfo),
        scope = CoroutineScope(dispatcher + SupervisorJob())
    )

    fun universalRequestDataStore(
        context: Context, dispatcher: CoroutineDispatcher
    ): DataStore<UniversalRequestStoreOuterClass.UniversalRequestStore> = DataStoreFactory.create(
        serializer = UniversalRequestStoreSerializer(),
        produceFile = { context.dataStoreFile(DATA_STORE_UNIVERSAL_REQUEST) },
        corruptionHandler = null,
        scope = CoroutineScope(dispatcher + SupervisorJob())
    )

    fun iapTransactionDataStore(
        context: Context, dispatcher: CoroutineDispatcher
    ): DataStore<ByteStringStore> = provideByteStringDataStore(context, dispatcher, DATA_STORE_IAP_TRANSACTION)

    fun webViewConfigurationDataStore(
        context: Context, dispatcher: CoroutineDispatcher
    ): DataStore<WebviewConfigurationStore.WebViewConfigurationStore> = DataStoreFactory.create(
        serializer = WebViewConfigurationStoreSerializer(),
        produceFile = { context.dataStoreFile(DATA_STORE_WEBVIEW_CONFIG) },
        corruptionHandler = null,
        scope = CoroutineScope(dispatcher + SupervisorJob())
    )

    fun asyncTokenStorage(
        tokenStorage: TokenStorage,
        sdkMetricsSender: SDKMetricsSender,
    ): AsyncTokenStorage = InMemoryAsyncTokenStorage(
        null, Handler(Looper.getMainLooper()), sdkMetricsSender, tokenStorage
    )

    fun volumeChangeMonitor(
        volumeChange: VolumeChange,
    ): VolumeChangeMonitor = VolumeChangeMonitor(SharedInstances.webViewEventSender, volumeChange)

    fun publicJsonStorage(): JsonStorage = provideJsonStorage(StorageType.PUBLIC)

    fun privateJsonStorage(): JsonStorage = provideJsonStorage(StorageType.PRIVATE)

    fun defaultNativeConfiguration(): NativeConfiguration = nativeConfiguration {
        adOperations = getDefaultAdOperations()
        initPolicy = getDefaultRequestPolicy()
        adPolicy = getDefaultRequestPolicy()
        otherPolicy = getDefaultRequestPolicy()
        operativeEventPolicy = getDefaultRequestPolicy()
        diagnosticEvents = diagnosticEventsConfiguration {
            enabled = true
            maxBatchSize = 10
            maxBatchIntervalMs = 30000
            ttmEnabled = false
        }
    }

    fun gatewayCacheDataStore(dataStore: DataStore<ByteStringStore>) = provideByteStringDataSource(dataStore)

    fun privacyDataStore(dataStore: DataStore<ByteStringStore>) = provideByteStringDataSource(dataStore)

    fun idfiDataStore(dataStore: DataStore<ByteStringStore>) = provideByteStringDataSource(dataStore)

    fun auidDataStore(dataStore: DataStore<ByteStringStore>) = provideByteStringDataSource(dataStore)

    fun privacyFsmDataStore(dataStore: DataStore<ByteStringStore>) = provideByteStringDataSource(dataStore)

    fun nativeConfigurationDataStore(dataStore: DataStore<ByteStringStore>) = provideByteStringDataSource(dataStore)

    fun glInfoDataStore(dataStore: DataStore<ByteStringStore>) = provideByteStringDataSource(dataStore)

    fun iapTransactionDataStore(dataStore: DataStore<ByteStringStore>) = provideByteStringDataSource(dataStore)

    fun measurementService(
        context: Context,
        dispatchers: ISDKDispatchers,
    ): MeasurementsService = MeasurementsService(context, dispatchers, SharedInstances.webViewEventSender)

    fun topicsService(
        context: Context, dispatchers: ISDKDispatchers
    ): TopicsService = TopicsService(context, dispatchers, SharedInstances.webViewEventSender)

    @OptIn(ExperimentalTime::class)
    fun provideHttpClient(
        configFileFromLocalStorage: ConfigFileFromLocalStorage,
        alternativeFlowReader: AlternativeFlowReader,
        dispatchers: ISDKDispatchers,
        sendDiagnosticEvent: SendDiagnosticEvent,
        context: Context
    ): HttpClient = runBlocking {
        val isAlternativeFlowEnabled = alternativeFlowReader()
        if (isAlternativeFlowEnabled) {
            val startTime = TimeSource.Monotonic.markNow()
            val client = withTimeoutOrNull(HTTP_CLIENT_FETCH_TIMEOUT) {
                buildNetworkClient(context, dispatchers)
            }
            val diagnosticResult = if (client == null) SYSTEM_CRONET_FAILURE else SYSTEM_CRONET_SUCCESS
            sendDiagnosticEvent(diagnosticResult, startTime.elapsedNow().toDouble(DurationUnit.MILLISECONDS))
            client ?: OkHttp3Client(dispatchers, OkHttpClient())
        } else {
            val config = runBlocking {
                runCatching { configFileFromLocalStorage(ConfigFileFromLocalStorage.Params()) }.getOrNull()?.getOrNull()
            }
            if (config?.experiments?.isOkHttpEnabled == true) {
                OkHttp3Client(dispatchers, OkHttpClient())
            } else {
                LegacyHttpClient(dispatchers)
            }
        }
    }

    private suspend fun buildNetworkClient(
        context: Context, dispatchers: ISDKDispatchers
    ): HttpClient = suspendCancellableCoroutine { continuation ->
        CronetProviderInstaller.installProvider(context).addOnCompleteListener {
            if (it.isSuccessful) {
                val cronetEngine =
                    CronetEngine.Builder(context).setStoragePath(context.filesDir.absolutePath).enableHttpCache(
                        CronetEngine.Builder.HTTP_CACHE_DISK, HTTP_CACHE_DISK_SIZE
                    ) // HTTP_CACHE_DISK provides 0-RTT support
                        .enableQuic(true).addQuicHint(GATEWAY_HOST, GATEWAY_PORT, GATEWAY_PORT)
                        .addQuicHint(CDN_CREATIVES_HOST, CDN_CREATIVES_PORT, CDN_CREATIVES_PORT).build()
                continuation.resume(CronetClient(cronetEngine, dispatchers))
            } else {
                continuation.resume(OkHttp3Client(dispatchers, OkHttpClient()))
            }
        }
    }

    private fun provideJsonStorage(storageType: StorageType): JsonStorage {
        check(StorageManager.init(ClientProperties.getApplicationContext())) {
            "StorageManager failed to initialize"
        }
        return StorageManager.getStorage(storageType)
    }

    private fun provideByteStringDataSource(dataStore: DataStore<ByteStringStore>): ByteStringDataSource {
        return AndroidByteStringDataSource(dataStore)
    }

    private fun provideByteStringDataStore(
        context: Context, dispatcher: CoroutineDispatcher, dataStoreFile: String
    ): DataStore<ByteStringStore> {
        return DataStoreFactory.create(
            serializer = ByteStringSerializer(),
            produceFile = { context.dataStoreFile(dataStoreFile) },
            corruptionHandler = null,
            scope = CoroutineScope(dispatcher + SupervisorJob())
        )
    }

    private fun getDefaultAdOperations(): AdOperationsConfiguration {
        return adOperationsConfiguration {
            loadTimeoutMs = UnityAdsConstants.AdOperations.LOAD_TIMEOUT_MS
            showTimeoutMs = UnityAdsConstants.AdOperations.SHOW_TIMEOUT_MS
            getTokenTimeoutMs = UnityAdsConstants.AdOperations.GET_TOKEN_TIMEOUT_MS
        }
    }

    private fun getDefaultRequestPolicy(): RequestPolicy {
        return requestPolicy {
            retryPolicy = getDefaultRequestRetryPolicy()
            timeoutPolicy = getDefaultRequestTimeoutPolicy()
        }
    }

    private fun getDefaultRequestRetryPolicy(): RequestRetryPolicy {
        return requestRetryPolicy {
            maxDuration = UnityAdsConstants.RequestPolicy.RETRY_MAX_DURATION
            retryWaitBase = UnityAdsConstants.RequestPolicy.RETRY_WAIT_BASE
            retryJitterPct = UnityAdsConstants.RequestPolicy.RETRY_JITTER_PCT
            shouldStoreLocally = UnityAdsConstants.RequestPolicy.SHOULD_STORE_LOCALLY
            retryMaxInterval = UnityAdsConstants.RequestPolicy.RETRY_MAX_INTERVAL
            retryScalingFactor = UnityAdsConstants.RequestPolicy.RETRY_SCALING_FACTOR
        }
    }

    private fun getDefaultRequestTimeoutPolicy(): RequestTimeoutPolicy {
        return requestTimeoutPolicy {
            connectTimeoutMs = UnityAdsConstants.RequestPolicy.CONNECT_TIMEOUT_MS
            readTimeoutMs = UnityAdsConstants.RequestPolicy.READ_TIMEOUT_MS
            writeTimeoutMs = UnityAdsConstants.RequestPolicy.WRITE_TIMEOUT_MS
            overallTimeoutMs = UnityAdsConstants.RequestPolicy.OVERALL_TIMEOUT_MS
        }
    }
}
