package com.unity3d.ads.core.domain.events

import com.google.protobuf.kotlin.toByteString
import com.unity3d.ads.core.data.datasource.UniversalRequestDataSource
import com.unity3d.ads.core.data.repository.OperativeEventRepository
import com.unity3d.ads.core.domain.GetUniversalRequestForPayLoad
import com.unity3d.ads.core.domain.work.BackgroundWorker
import com.unity3d.ads.core.domain.work.OperativeEventJob
import com.unity3d.ads.core.domain.work.UniversalRequestWorkerData
import com.unity3d.services.core.di.ServiceProvider.DEFAULT_DISPATCHER
import gateway.v1.UniversalRequestKt
import kotlinx.coroutines.CoroutineDispatcher
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.getAndUpdate
import kotlinx.coroutines.flow.launchIn
import kotlinx.coroutines.flow.onEach
import kotlinx.coroutines.withContext


import java.util.UUID


class OperativeEventObserver(
    private val getUniversalRequestForPayLoad: GetUniversalRequestForPayLoad,
    private val defaultDispatcher: CoroutineDispatcher,
    private val operativeEventRepository: OperativeEventRepository,
    private val universalRequestDataSource: UniversalRequestDataSource,
    private val backgroundWorker: BackgroundWorker
) {
    private val isRunning = MutableStateFlow(false)

    suspend operator fun invoke() = withContext(defaultDispatcher) {
        // If we are already collecting events, do nothing
        if (isRunning.getAndUpdate { true }) return@withContext
        operativeEventRepository.operativeEvents.onEach { operativeEventRequest ->
            val payload = UniversalRequestKt.payload {
                operativeEvent = operativeEventRequest
            }
            val fullRequest = getUniversalRequestForPayLoad(payload)

            val workId = UUID.randomUUID().toString()
            universalRequestDataSource.set(workId, fullRequest.toByteArray().toByteString())

            val universalRequestWorkerData = UniversalRequestWorkerData(workId)
            backgroundWorker<OperativeEventJob>(universalRequestWorkerData)
        }.launchIn(CoroutineScope(defaultDispatcher))
    }
}