package com.unity3d.ads.core.domain

import com.unity3d.ads.core.data.repository.SessionRepository
import com.unity3d.ads.gatewayclient.RequestPolicy
import com.unity3d.services.core.di.ServiceProvider.NAMED_INIT_REQ





internal class GetInitRequestPolicy(private val sessionRepository: SessionRepository): GetRequestPolicy {
    override fun invoke(): RequestPolicy {
        return RequestPolicy(
            maxDuration = sessionRepository.nativeConfiguration.initPolicy.retryPolicy.maxDuration,
            retryMaxInterval = sessionRepository.nativeConfiguration.initPolicy.retryPolicy.retryMaxInterval,
            retryWaitBase = sessionRepository.nativeConfiguration.initPolicy.retryPolicy.retryWaitBase,
            retryJitterPct = sessionRepository.nativeConfiguration.initPolicy.retryPolicy.retryJitterPct,
            connectTimeout = sessionRepository.nativeConfiguration.initPolicy.timeoutPolicy.connectTimeoutMs,
            readTimeout = sessionRepository.nativeConfiguration.initPolicy.timeoutPolicy.readTimeoutMs,
            writeTimeout = sessionRepository.nativeConfiguration.initPolicy.timeoutPolicy.writeTimeoutMs,
            shouldStoreLocally = sessionRepository.nativeConfiguration.initPolicy.retryPolicy.shouldStoreLocally
        )
    }
}