package com.unity3d.ads.core.domain

import com.unity3d.ads.core.data.repository.CacheRepository
import com.unity3d.ads.core.domain.SendDiagnosticEvent.Companion.SIZE_KB
import com.unity3d.ads.core.extensions.elapsedMillis

import kotlin.time.ExperimentalTime
import kotlin.time.TimeSource


@OptIn(ExperimentalTime::class)
class CommonClearCache(
    private val cacheRepository: CacheRepository,
    private val sendDiagnosticEvent: SendDiagnosticEvent
) : ClearCache {
    override suspend fun invoke() {
        val startTime = TimeSource.Monotonic.markNow()
        val currentSize = cacheRepository.getCacheSize()
        cacheRepository.clearCache()
        sendDiagnosticEvent.invoke(
            event = SendDiagnosticEvent.INIT_CLEAR_CACHE,
            value = startTime.elapsedMillis(),
            intTags = mapOf(
                SIZE_KB to (currentSize / 1024).toInt()
            )
        )
    }
}