package com.unity3d.ads.core.data.repository

import com.google.protobuf.ByteString
import com.unity3d.ads.core.data.datasource.DynamicDeviceInfoDataSource
import com.unity3d.ads.core.data.datasource.PrivacyDeviceInfoDataSource
import com.unity3d.ads.core.data.datasource.StaticDeviceInfoDataSource
import gateway.v1.AllowedPiiOuterClass.AllowedPii
import gateway.v1.DynamicDeviceInfoOuterClass.DynamicDeviceInfo
import gateway.v1.PiiOuterClass.Pii
import gateway.v1.StaticDeviceInfoOuterClass.StaticDeviceInfo
import kotlinx.coroutines.flow.MutableStateFlow
import org.koin.core.annotation.Single

@Single
internal class AndroidDeviceInfoRepository(
    private val staticDeviceInfoDataSource: StaticDeviceInfoDataSource,
    private val dynamicDeviceInfoDataSource: DynamicDeviceInfoDataSource,
    private val privacyDeviceInfoDataSource: PrivacyDeviceInfoDataSource,
) : DeviceInfoRepository {
    override val allowedPii = MutableStateFlow<AllowedPii>(AllowedPii.getDefaultInstance())

    override suspend fun staticDeviceInfo(): StaticDeviceInfo = staticDeviceInfoDataSource.fetch()

    override fun cachedStaticDeviceInfo(): StaticDeviceInfo = staticDeviceInfoDataSource.fetchCached()

    override val dynamicDeviceInfo: DynamicDeviceInfo
        get() = dynamicDeviceInfoDataSource.fetch()

    override val piiData: Pii
        get() = privacyDeviceInfoDataSource.fetch(allowed = allowedPii.value)

    override suspend fun getIdfi(): ByteString = staticDeviceInfoDataSource.getIdfi()

    override suspend fun getAuid(): ByteString = staticDeviceInfoDataSource.getAuid()

    override val analyticsUserId = staticDeviceInfoDataSource.analyticsUserId

    override val volumeSettingsChange = dynamicDeviceInfoDataSource.volumeSettingsChange
    override val ringerMode
        get() = dynamicDeviceInfoDataSource.getRingerMode()

    override val orientation
        get() = dynamicDeviceInfoDataSource.getOrientation()
    override val connectionTypeStr
        get() = dynamicDeviceInfoDataSource.getConnectionTypeStr()
    override val appName: String
        get() = staticDeviceInfoDataSource.getAppName()
    override val model: String
        get() = staticDeviceInfoDataSource.getModel()
    override val manufacturer: String
        get() = staticDeviceInfoDataSource.getManufacturer()
    override val osVersion: String
        get() = staticDeviceInfoDataSource.getOsVersion()
    override val hasInternet: Boolean
        get() = dynamicDeviceInfoDataSource.hasInternet()
}