package com.unity3d.ads.core.data.repository

import com.google.protobuf.ByteString
import com.unity3d.ads.core.domain.GetSharedDataTimestamps
import gateway.v1.CampaignStateOuterClass.*
import gateway.v1.campaignState
import gateway.v1.copy
import kotlinx.coroutines.flow.MutableStateFlow
import org.koin.core.annotation.Single

@Single
class AndroidCampaignRepository(
    private val getSharedDataTimestamps: GetSharedDataTimestamps
) : CampaignRepository {
    // WebView provides data and dataVersion
    // Key is opportunityId
    private val campaigns = MutableStateFlow(mapOf<String, Campaign>())

    override fun setCampaign(opportunityId: ByteString, campaign: Campaign) {
        campaigns.value += opportunityId.toStringUtf8() to campaign
    }

    override fun setShowTimestamp(opportunityId: ByteString) {
        getCampaign(opportunityId)?.let {
            setCampaign(opportunityId, it.copy { showTimestamp = getSharedDataTimestamps() })
        }
    }

    override fun getCampaign(opportunityId: ByteString): Campaign? {
        return campaigns.value[opportunityId.toStringUtf8()]
    }

    override fun removeState(opportunityId: ByteString) {
        campaigns.value -= opportunityId.toStringUtf8()
    }

    override fun setLoadTimestamp(opportunityId: ByteString) {
        getCampaign(opportunityId)?.let {
            setCampaign(opportunityId, it.copy { loadTimestamp = getSharedDataTimestamps() })
        }
    }

    override fun getCampaignState(): CampaignState {
        val (shown, loaded) = campaigns.value.values.partition(Campaign::hasShowTimestamp)

        return campaignState {
            shownCampaigns += shown
            loadedCampaigns += loaded
        }
    }
}