package com.unity3d.ads.core.domain.events

import com.google.protobuf.ByteString
import com.unity3d.ads.core.data.model.AdObject
import com.unity3d.ads.core.data.repository.OperativeEventRepository
import gateway.v1.OperativeEventRequestOuterClass.OperativeEventType
import org.koin.core.annotation.Single

@Single
internal class GetOperativeEventApi(
    private val operativeEventRepository: OperativeEventRepository,
    private val operativeEventRequest: GetOperativeEventRequest,
) {
    suspend operator fun invoke(
        operativeEventType: OperativeEventType,
        opportunityId: ByteString,
        trackingToken: ByteString,
        additionalEventData: ByteString,
        playerServerId: String? = null) {
        val operativeEvent = operativeEventRequest(
            operativeEventType = operativeEventType,
            opportunityId = opportunityId,
            additionalEventData = additionalEventData,
            loadTrackingToken = trackingToken,
            playerServerId = playerServerId
        )
        // Adds the event to the operative event flow
        operativeEventRepository.addOperativeEvent(operativeEvent)
    }

    suspend operator fun invoke(
        operativeEventType: OperativeEventType,
        adObject: AdObject,
        additionalEventData: ByteString
    ) {
        invoke(
            operativeEventType = operativeEventType,
            opportunityId = adObject.opportunityId,
            trackingToken = adObject.trackingToken,
            additionalEventData = additionalEventData,
            playerServerId = adObject.playerServerId
        )
    }
}