package com.unity3d.ads.core.domain.events

import org.koin.core.annotation.Single

/**
 * This class is a container for the event observers.
 * Invocation starts observing for new events.
 */
@Single
class EventObservers(
    val operativeEventObserver: OperativeEventObserver,
    val diagnosticEventObserver: DiagnosticEventObserver,
    val transactionEventObserver: TransactionEventObserver
) {
    suspend operator fun invoke() {
        operativeEventObserver()
        diagnosticEventObserver()
        transactionEventObserver()
    }
}