package com.unity3d.ads.core.extensions

import kotlinx.coroutines.delay
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.channelFlow
import kotlinx.coroutines.launch

fun <T> Flow<T>.timeoutAfter(timeoutMillis: Long, active: Boolean = true, block: suspend () -> Unit) = channelFlow {
    launch {
        collect {
            send(it)
        }
        close()
    }
    delay(timeoutMillis)
    if (active) {
        block()
    }
}