package com.unity3d.ads.core.domain

import com.unity3d.ads.core.data.manager.TransactionEventManager
import com.unity3d.ads.core.data.model.exception.InitializationException
import gateway.v1.InitializationResponseOuterClass.InitializationResponse
import com.unity3d.ads.core.data.repository.SessionRepository
import com.unity3d.services.core.di.ServiceProvider.NAMED_INIT_SCOPE
import com.unity3d.ads.core.domain.SendDiagnosticEvent.Companion.REASON_GATEWAY
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.launch
import org.koin.core.annotation.Named
import org.koin.core.annotation.Single

@Single
internal class HandleAndroidGatewayInitializationResponse(
    private val transactionEventManager: TransactionEventManager,
    private val triggerInitializationCompletedRequest: TriggerInitializationCompletedRequest,
    private val sessionRepository: SessionRepository,
    @Named(NAMED_INIT_SCOPE) private val sdkScope: CoroutineScope
) : HandleGatewayInitializationResponse {
    override suspend fun invoke(response: InitializationResponse) {
        if (response.hasError()) throw InitializationException(message = response.error.errorText, reason = REASON_GATEWAY)

        sessionRepository.nativeConfiguration = response.nativeConfiguration
        if (response.hasUniversalRequestUrl() && !response.universalRequestUrl.isNullOrEmpty()) {
            sessionRepository.gatewayUrl = response.universalRequestUrl
        }

        if (response.triggerInitializationCompletedRequest) {
            sdkScope.launch {
                triggerInitializationCompletedRequest()
            }
        }

        if (response.nativeConfiguration.enableIapEvent) {
            transactionEventManager()
        }

    }
}