package com.unity3d.ads.core.domain

import com.google.protobuf.ByteString
import com.unity3d.ads.core.data.datasource.WebviewConfigurationDataSource
import com.unity3d.ads.core.data.repository.CampaignRepository
import gateway.v1.UniversalRequestKt.payload
import gateway.v1.UniversalRequestOuterClass.UniversalRequest
import gateway.v1.adRequest
import com.unity3d.ads.core.data.repository.DeviceInfoRepository
import com.unity3d.ads.core.data.repository.SessionRepository
import org.koin.core.annotation.Single
import gateway.v1.AdRequestOuterClass
import gateway.v1.AdRequestOuterClass.AdRequestType
import gateway.v1.AdRequestOuterClass.BannerSize

@Single
internal class GetAndroidAdRequest(
    private val getUniversalRequestForPayLoad: GetUniversalRequestForPayLoad,
    private val sessionRepository: SessionRepository,
    private val deviceInfoRepository: DeviceInfoRepository,
    private val campaignRepository: CampaignRepository,
    private val webViewConfigurationDataSource: WebviewConfigurationDataSource
) : GetAdRequest {
    override suspend fun invoke(
        placement: String,
        impressionOpportunity: ByteString,
        size: BannerSize?,
    ): UniversalRequest {
        val request = adRequest {
            sessionCounters = sessionRepository.sessionCounters
            staticDeviceInfo = deviceInfoRepository.staticDeviceInfo()
            dynamicDeviceInfo = deviceInfoRepository.dynamicDeviceInfo
            impressionOpportunityId = impressionOpportunity
            placementId = placement
            requestImpressionConfiguration = true

            // scarSignal
            webviewVersion = webViewConfigurationDataSource.get().version
            campaignState = campaignRepository.getCampaignState()

            if (size == null) {
                adRequestType = AdRequestType.AD_REQUEST_TYPE_FULLSCREEN
            } else {
                adRequestType = AdRequestType.AD_REQUEST_TYPE_BANNER
                bannerSize = size
            }
        }
        val payload = payload {
            adRequest = request
        }
        return getUniversalRequestForPayLoad(payload)
    }


}