package com.unity3d.services.core.network.core

import okio.BufferedSink
import okio.Okio
import org.chromium.net.UrlRequest
import org.chromium.net.UrlResponseInfo
import java.io.ByteArrayOutputStream
import java.io.File
import java.nio.ByteBuffer
import java.nio.channels.Channels

internal abstract class UnityAdsUrlRequestCallback(val file: File?) : UrlRequest.Callback() {
    private val bytesReceived = ByteArrayOutputStream()
    private val receiveChannel = Channels.newChannel(bytesReceived)
    private lateinit var sink: BufferedSink

    override fun onRedirectReceived(request: UrlRequest, info: UrlResponseInfo?, newLocationUrl: String?) {
        request.followRedirect()
    }

    final override fun onResponseStarted(request: UrlRequest, info: UrlResponseInfo) {
        if (file?.exists() == true) {
            sink = Okio.buffer(Okio.sink(file))
        }
        request.read(ByteBuffer.allocateDirect(BYTE_BUFFER_CAPACITY_BYTES))
    }

    final override fun onReadCompleted(
        request: UrlRequest, info: UrlResponseInfo, byteBuffer: ByteBuffer
    ) {
        byteBuffer.flip()
        if (file?.exists() == true) {
            sink.write(byteBuffer)
        } else {
            receiveChannel.write(byteBuffer)
        }
        byteBuffer.clear()
        request.read(byteBuffer)
    }

    final override fun onSucceeded(request: UrlRequest, info: UrlResponseInfo) {
        val bodyBytes = bytesReceived.toByteArray()
        if (file != null && file.exists()) {
            sink.close()
        }
        onSucceeded(request, info, bodyBytes)
    }

    abstract fun onSucceeded(request: UrlRequest, info: UrlResponseInfo, bodyBytes: ByteArray)

    companion object {
        private const val BYTE_BUFFER_CAPACITY_BYTES = 64 * 1024
    }
}