package com.unity3d.ads.core.domain

import com.unity3d.ads.adplayer.ExposedFunction
import com.unity3d.ads.adplayer.Invocation
import com.unity3d.ads.core.data.model.AdData
import com.unity3d.ads.core.data.model.AdDataRefreshToken
import com.unity3d.ads.core.data.model.AdObject
import com.unity3d.ads.core.data.model.ImpressionConfig
import com.unity3d.services.core.di.KoinModule
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.SharedFlow
import kotlinx.coroutines.flow.onCompletion
import kotlinx.coroutines.flow.onEach
import kotlinx.coroutines.flow.onSubscription
import org.koin.core.annotation.Factory
import org.koin.core.qualifier.named

@Factory
internal class HandleInvocationsFromAdViewer {
    val scope = KoinModule.system.koin.createScope<HandleInvocationsFromAdViewer>()

    suspend operator fun invoke(
        onInvocations: SharedFlow<Invocation>,
        adData: String,
        adDataRefreshToken: String,
        impressionConfig: String,
        adObject: AdObject,
        onSubscription: suspend () -> Unit,
    ): Flow<Invocation> {
        scope.declare(AdData(adData))
        scope.declare(ImpressionConfig(impressionConfig))
        scope.declare(AdDataRefreshToken(adDataRefreshToken))
        scope.declare(adObject)

        return onInvocations
            .onSubscription { onSubscription() }
            .onEach {
                val exposedFunction = scope.getOrNull<ExposedFunction>(
                    named(it.location)
                ) ?: return@onEach

                it.handle { exposedFunction(it.parameters) }
            }
            .onCompletion {
                scope.close()
            }
    }

    companion object {
        const val KEY_AD_DATA = "adData"
        const val KEY_AD_DATA_REFRESH_TOKEN = "adDataRefreshToken"
        const val KEY_TRACKING_TOKEN = "trackingToken"
        const val KEY_IMPRESSION_CONFIG = "impressionConfig"
        const val KEY_NATIVE_CONTEXT = "nativeContext"
        const val KEY_LOAD_OPTIONS = "loadOptions"
        const val KEY_PACKAGE_NAME = "packageName"
        const val KEY_DOWNLOAD_URL = "url"
        const val KEY_DOWNLOAD_PRIORITY = "priority"
        const val KEY_OMID = "openMeasurement"
        const val KEY_OMJS_SESSION = "sessionFilePath"
        const val KEY_OMJS_SERVICE = "serviceFilePath"
        const val KEY_OM_VERSION = "version"
        const val KEY_OM_PARTNER = "partnerName"
        const val KEY_OM_PARTNER_VERSION = "partnerVersion"
        const val KEY_PRIVACY_UPDATE_CONTENT = "content"
        const val KEY_PRIVACY_UPDATE_VERSION = "version"
    }
}