package com.unity3d.ads.core.domain

import com.unity3d.ads.core.data.repository.SessionRepository
import com.unity3d.ads.gatewayclient.RequestPolicy
import com.unity3d.services.core.di.ServiceProvider.NAMED_OTHER_REQ
import org.koin.core.annotation.Named
import org.koin.core.annotation.Single

@Single
@Named(NAMED_OTHER_REQ)
internal class GetOtherRequestPolicy(private val sessionRepository: SessionRepository): GetRequestPolicy {
    override fun invoke(): RequestPolicy {
        return RequestPolicy(
            maxDuration = sessionRepository.nativeConfiguration.otherPolicy.retryPolicy.maxDuration,
            retryMaxInterval = sessionRepository.nativeConfiguration.otherPolicy.retryPolicy.retryMaxInterval,
            retryWaitBase = sessionRepository.nativeConfiguration.otherPolicy.retryPolicy.retryWaitBase,
            retryJitterPct = sessionRepository.nativeConfiguration.otherPolicy.retryPolicy.retryJitterPct,
            connectTimeout = sessionRepository.nativeConfiguration.otherPolicy.timeoutPolicy.connectTimeoutMs,
            readTimeout = sessionRepository.nativeConfiguration.otherPolicy.timeoutPolicy.readTimeoutMs,
            writeTimeout = sessionRepository.nativeConfiguration.otherPolicy.timeoutPolicy.writeTimeoutMs,
            shouldStoreLocally = sessionRepository.nativeConfiguration.otherPolicy.retryPolicy.shouldStoreLocally
        )
    }
}