package com.unity3d.ads.core.data.repository

import com.google.protobuf.ByteString
import com.unity3d.ads.core.data.model.InitializationState
import com.unity3d.ads.core.data.model.SessionChange
import gateway.v1.NativeConfigurationOuterClass.FeatureFlags
import gateway.v1.NativeConfigurationOuterClass.NativeConfiguration
import gateway.v1.SessionCountersOuterClass.SessionCounters
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.SharedFlow

interface SessionRepository {
    var sessionToken: ByteString
    var gatewayState: ByteString
    var nativeConfiguration: NativeConfiguration
    var gatewayUrl: String
    var initializationState: InitializationState
    val observeInitializationState: Flow<InitializationState>
    val isSdkInitialized: Boolean
    val isDiagnosticsEnabled: Boolean
    var sessionCounters: SessionCounters
    var gameId: String
    var shouldInitialize: Boolean
    val sessionId: ByteString
    val isTestModeEnabled: Boolean
    val onChange: SharedFlow<SessionChange>
    val featureFlags: FeatureFlags
    val headerBiddingTokenCounter: Int
    val isOmEnabled: Boolean

    suspend fun getGatewayCache(): ByteString
    suspend fun setGatewayCache(value: ByteString)
    suspend fun getPrivacy(): ByteString
    suspend fun setPrivacy(value: ByteString)
    suspend fun getPrivacyFsm(): ByteString
    suspend fun setPrivacyFsm(value: ByteString)
    fun incrementLoadRequestCount()
    fun incrementLoadRequestAdmCount()
    fun incrementBannerLoadRequestCount()
    fun incrementBannerLoadRequestAdmCount()
    fun incrementBannerImpressionCount()
    suspend fun persistNativeConfiguration()
}