package com.unity3d.ads.core.domain.om

import com.unity3d.ads.core.data.model.AdObject
import com.unity3d.ads.core.data.model.OMResult
import com.unity3d.ads.core.data.repository.OpenMeasurementRepository
import com.unity3d.ads.core.domain.SendDiagnosticEvent
import com.unity3d.ads.core.domain.SendDiagnosticEvent.Companion.OM_SESSION_START_FAILURE
import com.unity3d.ads.core.domain.SendDiagnosticEvent.Companion.OM_SESSION_START_SUCCESS
import org.json.JSONObject


class AndroidOmStartSession(
    private val openMeasurementRepository: OpenMeasurementRepository,
    private val sendDiagnosticEvent: SendDiagnosticEvent
) : CommonOmInteraction() {
    override suspend fun invoke(adObject: AdObject, options: JSONObject) {
        when (val result = openMeasurementRepository.startSession(
            adObject.opportunityId,
            getWebview(adObject),
            getOMidOptions(options)
        )) {
            is OMResult.Success -> sendDiagnosticEvent(OM_SESSION_START_SUCCESS)
            is OMResult.Failure -> sendDiagnosticEvent(
                OM_SESSION_START_FAILURE,
                tags = buildMap {
                    put(SendDiagnosticEvent.REASON, result.reason)
                    result.reasonDebug?.let {
                        put(SendDiagnosticEvent.REASON_DEBUG, result.reasonDebug)
                    }
                }
            )
        }
    }
}