package com.unity3d.ads.core.domain.om

import com.unity3d.ads.core.data.model.AdObject
import com.unity3d.ads.core.data.model.OMResult
import com.unity3d.ads.core.data.repository.OpenMeasurementRepository
import com.unity3d.ads.core.domain.SendDiagnosticEvent
import com.unity3d.ads.core.domain.SendDiagnosticEvent.Companion.OM_SESSION_FINISH_FAILURE
import com.unity3d.ads.core.domain.SendDiagnosticEvent.Companion.OM_SESSION_FINISH_SUCCESS

class AndroidOmFinishSession(
    private val openMeasurementRepository: OpenMeasurementRepository,
    private val sendDiagnosticEvent: SendDiagnosticEvent
) : OmFinishSession {
    override suspend fun invoke(adObject: AdObject) {
        when (val result = openMeasurementRepository.finishSession(adObject.opportunityId)) {
            is OMResult.Success -> sendDiagnosticEvent(OM_SESSION_FINISH_SUCCESS)
            is OMResult.Failure -> sendDiagnosticEvent(
                OM_SESSION_FINISH_FAILURE,
                tags = buildMap {
                    put(SendDiagnosticEvent.REASON, result.reason)
                    result.reasonDebug?.let {
                        put(SendDiagnosticEvent.REASON_DEBUG, result.reasonDebug)
                    }
                }
            )
        }
    }
}