package com.unity3d.ads.core.domain

import com.unity3d.ads.core.data.repository.DeviceInfoRepository
import com.unity3d.ads.core.data.repository.SessionRepository
import com.unity3d.ads.core.domain.InitializeAndroidBoldSDK.Companion.MSG_GATEWAY_DENIED
import gateway.v1.UniversalResponseOuterClass.UniversalResponse
import kotlinx.coroutines.flow.update

internal class HandleAndroidGatewayUniversalResponse(
    private val sessionRepository: SessionRepository,
    private val deviceInfoRepository: DeviceInfoRepository
) :
    HandleGatewayUniversalResponse {
    override suspend fun invoke(response: UniversalResponse) {
        if (response.hasError()) {
            sessionRepository.shouldInitialize = false
            throw IllegalStateException(MSG_GATEWAY_DENIED)
        }

        if (response.hasMutableData()) {
            val mutableData = response.mutableData

            deviceInfoRepository.allowedPii.update { mutableData.allowedPii }

            sessionRepository.gatewayState = mutableData.currentState

            if (mutableData.hasSessionToken()) {
                sessionRepository.sessionToken = mutableData.sessionToken
            }
            if (mutableData.hasPrivacy()) {
                sessionRepository.setPrivacy(mutableData.privacy)
            }
            if (mutableData.hasSessionCounters()) {
                sessionRepository.sessionCounters = mutableData.sessionCounters
            }
            if (mutableData.hasCache()) {
                sessionRepository.setGatewayCache(mutableData.cache)
            }
            if (mutableData.hasPrivacyFsm()) {
                sessionRepository.setPrivacyFsm(mutableData.privacyFsm)
            }
        }
    }
}