package com.unity3d.ads.core.data.model

import androidx.datastore.core.CorruptionException
import androidx.datastore.core.Serializer
import com.google.protobuf.InvalidProtocolBufferException
import java.io.InputStream
import java.io.OutputStream
import WebviewConfigurationStore.WebViewConfigurationStore

class WebViewConfigurationStoreSerializer : Serializer<WebViewConfigurationStore> {

    override val defaultValue: WebViewConfigurationStore = WebViewConfigurationStore.getDefaultInstance()

    override suspend fun readFrom(input: InputStream): WebViewConfigurationStore {
        try {
            return WebViewConfigurationStore.parseFrom(input)
        } catch (exception: InvalidProtocolBufferException) {
            throw CorruptionException("Cannot read proto.", exception)
        }
    }

    override suspend fun writeTo(t: WebViewConfigurationStore, output: OutputStream) = t.writeTo(output)
}