/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.request.metrics;

import com.unity3d.services.core.configuration.Configuration;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.request.metrics.ISDKMetrics;
import com.unity3d.services.core.request.metrics.Metric;
import com.unity3d.services.core.request.metrics.MetricSender;
import com.unity3d.services.core.request.metrics.MetricSenderWithBatch;
import java.util.List;
import java.util.Map;
import java.util.Random;

public final class SDKMetrics {
    private static final String NULL_INSTANCE_METRICS_URL = "nullInstanceMetricsUrl";
    private static ISDKMetrics _instance;
    private static MetricSenderWithBatch _batchedSender;

    public static void setConfiguration(Configuration configuration) {
        if (configuration == null) {
            DeviceLog.debug("Metrics will not be sent from the device for this session due to misconfiguration");
            return;
        }
        if (_instance instanceof MetricSender) {
            ((MetricSender)_instance).shutdown();
        }
        Random random = new Random();
        if (configuration.getMetricSampleRate() >= (double)(random.nextInt(99) + 1)) {
            _instance = new MetricSender(configuration.getMetricsUrl());
        } else {
            DeviceLog.debug("Metrics will not be sent from the device for this session");
            _instance = new NullInstance(NULL_INSTANCE_METRICS_URL);
        }
        if (_batchedSender == null) {
            _batchedSender = new MetricSenderWithBatch(_instance);
        } else {
            _batchedSender.updateOriginal(_instance);
        }
        _batchedSender.sendQueueIfNeeded();
    }

    public static synchronized ISDKMetrics getInstance() {
        if (_instance == null) {
            _instance = new NullInstance(null);
        }
        if (_batchedSender == null) {
            _batchedSender = new MetricSenderWithBatch(_instance);
        }
        return _batchedSender;
    }

    private static final class NullInstance
    implements ISDKMetrics {
        private final String _metricEndpoint;

        public NullInstance(String url) {
            this._metricEndpoint = url;
        }

        @Override
        public void sendEvent(String event) {
            DeviceLog.debug("Metric " + event + " was skipped from being sent");
        }

        @Override
        public void sendEvent(String event, String value, Map<String, String> tags) {
            this.sendEvent(event);
        }

        @Override
        public void sendEvent(String event, Map<String, String> tags) {
            this.sendEvent(event);
        }

        @Override
        public void sendMetric(Metric metric) {
            DeviceLog.debug("Metric " + metric + " was skipped from being sent");
        }

        @Override
        public void sendMetrics(List<Metric> metrics) {
            DeviceLog.debug("Metrics: " + metrics + " was skipped from being sent");
        }

        @Override
        public String getMetricEndPoint() {
            return this._metricEndpoint;
        }
    }
}

