/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.configuration;

import com.unity3d.services.core.log.DeviceLog;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class Experiments {
    private static final String TSI_TAG_INIT_ENABLED = "tsi";
    private static final String TSI_TAG_INIT_POST = "tsi_p";
    private static final String TSI_TAG_FORWARD_FEATURE_FLAGS = "fff";
    private static final String TSI_TAG_UPDATE_PII_FIELDS = "tsi_upii";
    private static final String TSI_TAG_DEVELOPER_CONSENT = "tsi_dc";
    private static final String TSI_TAG_NATIVE_TOKEN = "tsi_nt";
    private final JSONObject _experimentData;

    public Experiments() {
        this(null);
    }

    public Experiments(JSONObject experimentData) {
        this._experimentData = experimentData == null ? new JSONObject() : experimentData;
    }

    public void setTwoStageInitializationEnabled(boolean tsiEnabled) {
        try {
            this._experimentData.put(TSI_TAG_INIT_ENABLED, tsiEnabled);
        }
        catch (JSONException e) {
            DeviceLog.warning("Could not set TSI flag to " + tsiEnabled);
        }
    }

    public boolean isTwoStageInitializationEnabled() {
        return this._experimentData.optBoolean(TSI_TAG_INIT_ENABLED, false);
    }

    public boolean isPOSTMethodInConfigRequestEnabled() {
        return this._experimentData.optBoolean(TSI_TAG_INIT_POST, false);
    }

    public boolean isForwardExperimentsToWebViewEnabled() {
        return this._experimentData.optBoolean(TSI_TAG_FORWARD_FEATURE_FLAGS, false);
    }

    public boolean isNativeTokenEnabled() {
        return this._experimentData.optBoolean(TSI_TAG_NATIVE_TOKEN, false);
    }

    public boolean isUpdatePiiFields() {
        return this._experimentData.optBoolean(TSI_TAG_UPDATE_PII_FIELDS, false);
    }

    public boolean isHandleDeveloperConsent() {
        return this._experimentData.optBoolean(TSI_TAG_DEVELOPER_CONSENT, false);
    }

    public JSONObject getExperimentData() {
        return this._experimentData;
    }

    public Map<String, String> getExperimentTags() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(TSI_TAG_INIT_ENABLED, String.valueOf(this.isTwoStageInitializationEnabled()));
        map.put(TSI_TAG_INIT_POST, String.valueOf(this.isPOSTMethodInConfigRequestEnabled()));
        map.put(TSI_TAG_FORWARD_FEATURE_FLAGS, String.valueOf(this.isForwardExperimentsToWebViewEnabled()));
        map.put(TSI_TAG_UPDATE_PII_FIELDS, String.valueOf(this.isUpdatePiiFields()));
        map.put(TSI_TAG_DEVELOPER_CONSENT, String.valueOf(this.isHandleDeveloperConsent()));
        map.put(TSI_TAG_NATIVE_TOKEN, String.valueOf(this.isNativeTokenEnabled()));
        return map;
    }
}

