/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ads.operation.show;

import android.app.Activity;
import android.graphics.Point;
import android.os.Build;
import android.text.TextUtils;
import android.view.Display;
import android.view.WindowManager;
import com.unity3d.ads.UnityAds;
import com.unity3d.services.ads.operation.AdModule;
import com.unity3d.services.ads.operation.show.IShowModule;
import com.unity3d.services.ads.operation.show.IShowOperation;
import com.unity3d.services.ads.operation.show.ShowModuleDecoratorTimeout;
import com.unity3d.services.ads.operation.show.ShowOperation;
import com.unity3d.services.ads.operation.show.ShowOperationState;
import com.unity3d.services.core.device.Device;
import com.unity3d.services.core.misc.Utilities;
import com.unity3d.services.core.properties.ClientProperties;
import com.unity3d.services.core.request.metrics.ISDKMetricSender;
import com.unity3d.services.core.request.metrics.SDKMetricEvents;
import com.unity3d.services.core.request.metrics.SDKMetricSender;
import com.unity3d.services.core.webview.bridge.CallbackStatus;
import com.unity3d.services.core.webview.bridge.IWebViewBridgeInvoker;
import com.unity3d.services.core.webview.bridge.invocation.IWebViewBridgeInvocationCallback;
import com.unity3d.services.core.webview.bridge.invocation.WebViewBridgeInvocation;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class ShowModule
extends AdModule<IShowOperation, ShowOperationState>
implements IShowModule {
    private static IShowModule instance;
    public static String errorMsgPlacementIdNull;

    public static IShowModule getInstance() {
        if (instance == null) {
            instance = new ShowModuleDecoratorTimeout(new ShowModule(new SDKMetricSender()));
        }
        return instance;
    }

    public ShowModule(ISDKMetricSender sdkMetricSender) {
        super(sdkMetricSender);
    }

    @Override
    public void executeAdOperation(IWebViewBridgeInvoker webViewBridgeInvoker, final ShowOperationState state) {
        if (TextUtils.isEmpty((CharSequence)state.placementId)) {
            this.sendOnUnityAdsFailedToShow(state, errorMsgPlacementIdNull, UnityAds.UnityAdsShowError.INVALID_ARGUMENT);
            return;
        }
        ShowOperation showOperation = new ShowOperation(state, new WebViewBridgeInvocation(this._executorService, webViewBridgeInvoker, new IWebViewBridgeInvocationCallback(){

            @Override
            public void onSuccess() {
            }

            @Override
            public void onFailure(String message, CallbackStatus callbackStatus) {
                ShowModule.this.sendOnUnityAdsFailedToShow(state, message, UnityAds.UnityAdsShowError.INTERNAL_ERROR);
                final String cbs = callbackStatus == null ? "invocationFailure" : callbackStatus.toString();
                ShowModule.this._sdkMetricSender.sendSDKMetricEventWithTag(SDKMetricEvents.native_show_callback_error, (Map<String, String>)new HashMap<String, String>(){
                    {
                        this.put("cbs", cbs);
                    }
                });
                ShowModule.this.remove(state.id);
            }

            @Override
            public void onTimeout() {
                ShowModule.this.sendOnUnityAdsFailedToShow(state, "[UnityAds] Show Invocation Timeout", UnityAds.UnityAdsShowError.INTERNAL_ERROR);
                ShowModule.this._sdkMetricSender.sendSDKMetricEvent(SDKMetricEvents.native_show_callback_timeout);
                ShowModule.this.remove(state.id);
            }
        }));
        ClientProperties.setActivity(state.activity);
        Activity cfr_ignored_0 = state.activity;
        Display defaultDisplay = ((WindowManager)state.activity.getSystemService("window")).getDefaultDisplay();
        JSONObject parameters = new JSONObject();
        JSONObject options = new JSONObject();
        JSONObject display = new JSONObject();
        try {
            display.put("requestedOrientation", state.activity.getRequestedOrientation());
            display.put("rotation", defaultDisplay.getRotation());
            if (Build.VERSION.SDK_INT >= 13) {
                Point displaySize = new Point();
                defaultDisplay.getSize(displaySize);
                display.put("width", displaySize.x);
                display.put("height", displaySize.y);
            } else {
                display.put("width", defaultDisplay.getWidth());
                display.put("height", defaultDisplay.getHeight());
            }
            options.put("display", (Object)display);
            options.put("headerBiddingOptions", (Object)state.showOptions.getData());
            parameters.put("options", (Object)options);
            parameters.put("listenerId", (Object)showOperation.getId());
            parameters.put("placementId", (Object)state.placementId);
            parameters.put("time", Device.getElapsedRealtime());
        }
        catch (JSONException e) {
            this.sendOnUnityAdsFailedToShow(state, "[UnityAds] Error creating show options", UnityAds.UnityAdsShowError.INTERNAL_ERROR);
            return;
        }
        catch (NullPointerException e) {
            this.sendOnUnityAdsFailedToShow(state, "[UnityAds] Error creating show options", UnityAds.UnityAdsShowError.INTERNAL_ERROR);
            return;
        }
        this.set(showOperation);
        showOperation.invoke(state.configuration.getWebViewBridgeTimeout(), parameters);
    }

    @Override
    public void onUnityAdsShowFailure(String id, UnityAds.UnityAdsShowError error, String message) {
        IShowOperation showOperation = (IShowOperation)this.get(id);
        if (showOperation == null || showOperation.getShowOperationState() == null) {
            return;
        }
        showOperation.onUnityAdsShowFailure(showOperation.getShowOperationState().placementId, error, message);
        this.remove(id);
    }

    @Override
    public void onUnityAdsShowConsent(String id) {
        IShowOperation showOperation = (IShowOperation)this.get(id);
        if (showOperation == null || showOperation.getShowOperationState() == null) {
            return;
        }
    }

    @Override
    public void onUnityAdsShowStart(String id) {
        IShowOperation showOperation = (IShowOperation)this.get(id);
        if (showOperation == null || showOperation.getShowOperationState() == null) {
            return;
        }
        showOperation.onUnityAdsShowStart(showOperation.getShowOperationState().placementId);
    }

    @Override
    public void onUnityAdsShowClick(String id) {
        IShowOperation showOperation = (IShowOperation)this.get(id);
        if (showOperation == null || showOperation.getShowOperationState() == null) {
            return;
        }
        showOperation.onUnityAdsShowClick(showOperation.getShowOperationState().placementId);
    }

    @Override
    public void onUnityAdsShowComplete(String id, UnityAds.UnityAdsShowCompletionState state) {
        IShowOperation showOperation = (IShowOperation)this.get(id);
        if (showOperation == null || showOperation.getShowOperationState() == null) {
            return;
        }
        showOperation.onUnityAdsShowComplete(showOperation.getShowOperationState().placementId, state);
        this.remove(id);
    }

    private void sendOnUnityAdsFailedToShow(final ShowOperationState showOperationState, final String errorMessage, final UnityAds.UnityAdsShowError errorCode) {
        if (showOperationState == null || showOperationState.listener == null) {
            return;
        }
        Utilities.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                showOperationState.listener.onUnityAdsShowFailure(showOperationState.placementId, errorCode, errorMessage);
            }
        });
    }

    static {
        errorMsgPlacementIdNull = "[UnityAds] Placement ID cannot be null";
    }
}

