/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.store.gpbl.proxies;

import com.unity3d.services.core.reflection.GenericListenerProxy;
import com.unity3d.services.store.gpbl.bridges.BillingResultBridge;
import com.unity3d.services.store.gpbl.bridges.SkuDetailsBridge;
import com.unity3d.services.store.listeners.ISkuDetailsResponseListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class SkuDetailsResponseListenerProxy
extends GenericListenerProxy {
    private static final String onSkuDetailsResponseMethodName = "onSkuDetailsResponse";
    private ISkuDetailsResponseListener _skuDetailsResponseListener;

    public SkuDetailsResponseListenerProxy(ISkuDetailsResponseListener skuDetailsResponseListener) {
        this._skuDetailsResponseListener = skuDetailsResponseListener;
    }

    @Override
    public Class<?> getProxyClass() throws ClassNotFoundException {
        return SkuDetailsResponseListenerProxy.getProxyListenerClass();
    }

    public static Class<?> getProxyListenerClass() throws ClassNotFoundException {
        return Class.forName("com.android.billingclient.api.SkuDetailsResponseListener");
    }

    @Override
    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        Object result = null;
        if (m.getName().equals(onSkuDetailsResponseMethodName)) {
            this.onSkuDetailsResponse(args[0], (List)args[1]);
        } else {
            result = super.invoke(proxy, m, args);
        }
        return result;
    }

    public void onSkuDetailsResponse(Object billingResult, List<Object> skuDetailsList) {
        ArrayList<SkuDetailsBridge> skuDetailsBridges = new ArrayList<SkuDetailsBridge>();
        for (Object skuDetails : skuDetailsList) {
            skuDetailsBridges.add(new SkuDetailsBridge(skuDetails));
        }
        if (this._skuDetailsResponseListener != null) {
            this._skuDetailsResponseListener.onBillingResponse(new BillingResultBridge(billingResult), (List<SkuDetailsBridge>)skuDetailsBridges);
        }
    }
}

