/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.device;

import android.annotation.TargetApi;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.unity3d.services.core.log.DeviceLog;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

@TargetApi(value=9)
public class AdvertisingId {
    private static final String ADVERTISING_ID_SERVICE_NAME = "com.google.android.gms.ads.identifier.internal.IAdvertisingIdService";
    private static AdvertisingId instance = null;
    private String advertisingIdentifier = null;
    private boolean limitedAdvertisingTracking = false;

    private static AdvertisingId getInstance() {
        if (instance == null) {
            instance = new AdvertisingId();
        }
        return instance;
    }

    public static void init(Context context) {
        AdvertisingId.getInstance().fetchAdvertisingId(context);
    }

    public static String getAdvertisingTrackingId() {
        return AdvertisingId.getInstance().advertisingIdentifier;
    }

    public static boolean getLimitedAdTracking() {
        return AdvertisingId.getInstance().limitedAdvertisingTracking;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchAdvertisingId(Context context) {
        GoogleAdvertisingServiceConnection connection = new GoogleAdvertisingServiceConnection();
        Intent localIntent = new Intent("com.google.android.gms.ads.identifier.service.START");
        localIntent.setPackage("com.google.android.gms");
        boolean didBind = false;
        try {
            didBind = context.bindService(localIntent, (ServiceConnection)connection, 1);
        }
        catch (Exception e) {
            DeviceLog.exception("Couldn't bind to identifier service intent", e);
        }
        try {
            if (didBind) {
                GoogleAdvertisingInfo advertisingInfo = GoogleAdvertisingInfo.GoogleAdvertisingInfoBinder.create(connection.getBinder());
                this.advertisingIdentifier = advertisingInfo.getId();
                this.limitedAdvertisingTracking = advertisingInfo.getEnabled(true);
            }
        }
        catch (Exception e) {
            DeviceLog.exception("Couldn't get advertising info", e);
        }
        finally {
            if (didBind) {
                context.unbindService((ServiceConnection)connection);
            }
        }
    }

    private class GoogleAdvertisingServiceConnection
    implements ServiceConnection {
        boolean _consumed = false;
        private final BlockingQueue<IBinder> _binderQueue = new LinkedBlockingQueue<IBinder>();

        private GoogleAdvertisingServiceConnection() {
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
            try {
                this._binderQueue.put(service);
            }
            catch (InterruptedException localInterruptedException) {
                DeviceLog.debug("Couldn't put service to binder que");
            }
        }

        public void onServiceDisconnected(ComponentName name) {
        }

        public IBinder getBinder() throws InterruptedException {
            if (this._consumed) {
                throw new IllegalStateException();
            }
            this._consumed = true;
            return this._binderQueue.take();
        }
    }

    private static interface GoogleAdvertisingInfo
    extends IInterface {
        public String getId() throws RemoteException;

        public boolean getEnabled(boolean var1) throws RemoteException;

        public static abstract class GoogleAdvertisingInfoBinder
        extends Binder
        implements GoogleAdvertisingInfo {
            public static GoogleAdvertisingInfo create(IBinder binder) {
                if (binder == null) {
                    return null;
                }
                IInterface localIInterface = binder.queryLocalInterface(AdvertisingId.ADVERTISING_ID_SERVICE_NAME);
                if (localIInterface != null && localIInterface instanceof GoogleAdvertisingInfo) {
                    return (GoogleAdvertisingInfo)localIInterface;
                }
                return new GoogleAdvertisingInfoImplementation(binder);
            }

            public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
                switch (code) {
                    case 1: {
                        data.enforceInterface(AdvertisingId.ADVERTISING_ID_SERVICE_NAME);
                        String str1 = this.getId();
                        reply.writeNoException();
                        reply.writeString(str1);
                        return true;
                    }
                    case 2: {
                        data.enforceInterface(AdvertisingId.ADVERTISING_ID_SERVICE_NAME);
                        boolean bool1 = 0 != data.readInt();
                        boolean bool2 = this.getEnabled(bool1);
                        reply.writeNoException();
                        reply.writeInt(bool2 ? 1 : 0);
                        return true;
                    }
                }
                return super.onTransact(code, data, reply, flags);
            }

            private static class GoogleAdvertisingInfoImplementation
            implements GoogleAdvertisingInfo {
                private final IBinder _binder;

                GoogleAdvertisingInfoImplementation(IBinder binder) {
                    this._binder = binder;
                }

                public IBinder asBinder() {
                    return this._binder;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public String getId() throws RemoteException {
                    String str;
                    Parcel localParcel1 = Parcel.obtain();
                    Parcel localParcel2 = Parcel.obtain();
                    try {
                        localParcel1.writeInterfaceToken(AdvertisingId.ADVERTISING_ID_SERVICE_NAME);
                        this._binder.transact(1, localParcel1, localParcel2, 0);
                        localParcel2.readException();
                        str = localParcel2.readString();
                    }
                    finally {
                        localParcel2.recycle();
                        localParcel1.recycle();
                    }
                    return str;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean getEnabled(boolean paramBoolean) throws RemoteException {
                    boolean bool;
                    Parcel localParcel1 = Parcel.obtain();
                    Parcel localParcel2 = Parcel.obtain();
                    try {
                        localParcel1.writeInterfaceToken(AdvertisingId.ADVERTISING_ID_SERVICE_NAME);
                        localParcel1.writeInt(paramBoolean ? 1 : 0);
                        this._binder.transact(2, localParcel1, localParcel2, 0);
                        localParcel2.readException();
                        bool = 0 != localParcel2.readInt();
                    }
                    finally {
                        localParcel2.recycle();
                        localParcel1.recycle();
                    }
                    return bool;
                }
            }
        }
    }
}

