/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ads.load;

import com.unity3d.services.ads.load.ILoadBridge;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.webview.WebViewApp;
import com.unity3d.services.core.webview.WebViewEventCategory;
import java.util.Map;
import org.json.JSONObject;

public class LoadBridge
implements ILoadBridge {
    @Override
    public void loadPlacements(Map<String, Integer> placements) {
        try {
            JSONObject jsonObject = new JSONObject();
            for (Map.Entry<String, Integer> entry : placements.entrySet()) {
                jsonObject.put(entry.getKey(), entry.getValue().intValue());
            }
            if (WebViewApp.getCurrentApp() != null) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.LOAD_API, LoadEvent.LOAD_PLACEMENTS, jsonObject);
            }
        }
        catch (Exception exception) {
            DeviceLog.error("An exception was thrown while loading placements " + exception.getLocalizedMessage());
        }
    }

    public static enum LoadEvent {
        LOAD_PLACEMENTS;

    }
}

