/*
 * Decompiled with CFR 0.152.
 */
package com.unfbx.chatgpt.entity.chat;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.unfbx.chatgpt.entity.chat.BaseChatCompletion;
import com.unfbx.chatgpt.entity.chat.Message;
import com.unfbx.chatgpt.utils.TikTokensUtil;
import java.io.Serializable;
import java.util.List;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ChatCompletion
extends BaseChatCompletion
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(ChatCompletion.class);
    @NonNull
    private List<Message> messages;

    public long tokens() {
        if (CollectionUtil.isEmpty(this.messages) || StrUtil.isBlank((CharSequence)this.getModel())) {
            log.warn("\u53c2\u6570\u5f02\u5e38model\uff1a{}\uff0cprompt\uff1a{}", (Object)this.getModel(), this.messages);
            return 0L;
        }
        return TikTokensUtil.tokens(this.getModel(), this.messages);
    }

    protected ChatCompletion(ChatCompletionBuilder<?, ?> b) {
        super(b);
        this.messages = ((ChatCompletionBuilder)b).messages;
        if (this.messages == null) {
            throw new NullPointerException("messages is marked non-null but is null");
        }
    }

    public static ChatCompletionBuilder<?, ?> builder() {
        return new ChatCompletionBuilderImpl();
    }

    @NonNull
    public List<Message> getMessages() {
        return this.messages;
    }

    public void setMessages(@NonNull List<Message> messages) {
        if (messages == null) {
            throw new NullPointerException("messages is marked non-null but is null");
        }
        this.messages = messages;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatCompletion)) {
            return false;
        }
        ChatCompletion other = (ChatCompletion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Message> this$messages = this.getMessages();
        List<Message> other$messages = other.getMessages();
        return !(this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ChatCompletion;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Message> $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ChatCompletion(messages=" + this.getMessages() + ")";
    }

    public ChatCompletion() {
    }

    public ChatCompletion(@NonNull List<Message> messages) {
        if (messages == null) {
            throw new NullPointerException("messages is marked non-null but is null");
        }
        this.messages = messages;
    }

    private static final class ChatCompletionBuilderImpl
    extends ChatCompletionBuilder<ChatCompletion, ChatCompletionBuilderImpl> {
        private ChatCompletionBuilderImpl() {
        }

        @Override
        protected ChatCompletionBuilderImpl self() {
            return this;
        }

        @Override
        public ChatCompletion build() {
            return new ChatCompletion(this);
        }
    }

    public static abstract class ChatCompletionBuilder<C extends ChatCompletion, B extends ChatCompletionBuilder<C, B>>
    extends BaseChatCompletion.BaseChatCompletionBuilder<C, B> {
        private List<Message> messages;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B messages(@NonNull List<Message> messages) {
            if (messages == null) {
                throw new NullPointerException("messages is marked non-null but is null");
            }
            this.messages = messages;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ChatCompletion.ChatCompletionBuilder(super=" + super.toString() + ", messages=" + this.messages + ")";
        }
    }
}

