/*
 * Decompiled with CFR 0.152.
 */
package com.unfbx.chatgpt;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.unfbx.chatgpt.OpenAiApi;
import com.unfbx.chatgpt.entity.Tts.TextToSpeech;
import com.unfbx.chatgpt.entity.assistant.Assistant;
import com.unfbx.chatgpt.entity.assistant.AssistantFile;
import com.unfbx.chatgpt.entity.assistant.AssistantFileResponse;
import com.unfbx.chatgpt.entity.assistant.AssistantListResponse;
import com.unfbx.chatgpt.entity.assistant.AssistantResponse;
import com.unfbx.chatgpt.entity.assistant.message.MessageFileResponse;
import com.unfbx.chatgpt.entity.assistant.message.MessageResponse;
import com.unfbx.chatgpt.entity.assistant.message.ModifyMessage;
import com.unfbx.chatgpt.entity.assistant.run.ModifyRun;
import com.unfbx.chatgpt.entity.assistant.run.Run;
import com.unfbx.chatgpt.entity.assistant.run.RunResponse;
import com.unfbx.chatgpt.entity.assistant.run.RunStepResponse;
import com.unfbx.chatgpt.entity.assistant.run.ThreadRun;
import com.unfbx.chatgpt.entity.assistant.run.ToolOutputBody;
import com.unfbx.chatgpt.entity.assistant.thread.ModifyThread;
import com.unfbx.chatgpt.entity.assistant.thread.Thread;
import com.unfbx.chatgpt.entity.assistant.thread.ThreadMessage;
import com.unfbx.chatgpt.entity.assistant.thread.ThreadResponse;
import com.unfbx.chatgpt.entity.billing.BillingUsage;
import com.unfbx.chatgpt.entity.billing.CreditGrantsResponse;
import com.unfbx.chatgpt.entity.billing.Subscription;
import com.unfbx.chatgpt.entity.chat.BaseChatCompletion;
import com.unfbx.chatgpt.entity.chat.BaseMessage;
import com.unfbx.chatgpt.entity.chat.ChatChoice;
import com.unfbx.chatgpt.entity.chat.ChatCompletion;
import com.unfbx.chatgpt.entity.chat.ChatCompletionResponse;
import com.unfbx.chatgpt.entity.chat.ChatCompletionWithPicture;
import com.unfbx.chatgpt.entity.chat.FunctionCall;
import com.unfbx.chatgpt.entity.chat.Functions;
import com.unfbx.chatgpt.entity.chat.Message;
import com.unfbx.chatgpt.entity.common.DeleteResponse;
import com.unfbx.chatgpt.entity.common.OpenAiResponse;
import com.unfbx.chatgpt.entity.common.PageRequest;
import com.unfbx.chatgpt.entity.completions.Completion;
import com.unfbx.chatgpt.entity.completions.CompletionResponse;
import com.unfbx.chatgpt.entity.edits.Edit;
import com.unfbx.chatgpt.entity.edits.EditResponse;
import com.unfbx.chatgpt.entity.embeddings.Embedding;
import com.unfbx.chatgpt.entity.embeddings.EmbeddingResponse;
import com.unfbx.chatgpt.entity.engines.Engine;
import com.unfbx.chatgpt.entity.files.File;
import com.unfbx.chatgpt.entity.files.UploadFileResponse;
import com.unfbx.chatgpt.entity.fineTune.Event;
import com.unfbx.chatgpt.entity.fineTune.FineTune;
import com.unfbx.chatgpt.entity.fineTune.FineTuneDeleteResponse;
import com.unfbx.chatgpt.entity.fineTune.FineTuneResponse;
import com.unfbx.chatgpt.entity.fineTune.job.FineTuneJob;
import com.unfbx.chatgpt.entity.fineTune.job.FineTuneJobEvent;
import com.unfbx.chatgpt.entity.fineTune.job.FineTuneJobListResponse;
import com.unfbx.chatgpt.entity.fineTune.job.FineTuneJobResponse;
import com.unfbx.chatgpt.entity.images.Image;
import com.unfbx.chatgpt.entity.images.ImageEdit;
import com.unfbx.chatgpt.entity.images.ImageResponse;
import com.unfbx.chatgpt.entity.images.ImageVariations;
import com.unfbx.chatgpt.entity.images.Item;
import com.unfbx.chatgpt.entity.models.Model;
import com.unfbx.chatgpt.entity.models.ModelResponse;
import com.unfbx.chatgpt.entity.moderations.Moderation;
import com.unfbx.chatgpt.entity.moderations.ModerationResponse;
import com.unfbx.chatgpt.entity.whisper.Transcriptions;
import com.unfbx.chatgpt.entity.whisper.Translations;
import com.unfbx.chatgpt.entity.whisper.WhisperResponse;
import com.unfbx.chatgpt.exception.BaseException;
import com.unfbx.chatgpt.exception.CommonError;
import com.unfbx.chatgpt.function.KeyRandomStrategy;
import com.unfbx.chatgpt.function.KeyStrategyFunction;
import com.unfbx.chatgpt.interceptor.DefaultOpenAiAuthInterceptor;
import com.unfbx.chatgpt.interceptor.OpenAiAuthInterceptor;
import com.unfbx.chatgpt.plugin.PluginAbstract;
import com.unfbx.chatgpt.plugin.PluginParam;
import io.reactivex.Single;
import java.io.IOException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class OpenAiClient {
    private static final Logger log = LoggerFactory.getLogger(OpenAiClient.class);
    @NotNull
    private List<String> apiKey;
    private String apiHost;
    private OpenAiApi openAiApi;
    private OkHttpClient okHttpClient;
    private KeyStrategyFunction<List<String>, String> keyStrategy;
    private OpenAiAuthInterceptor authInterceptor;
    private PageRequest pageRequest = PageRequest.builder().build();

    public static Builder builder() {
        return new Builder();
    }

    private OpenAiClient(Builder builder) {
        if (CollectionUtil.isEmpty((Collection)builder.apiKey)) {
            throw new BaseException(CommonError.API_KEYS_NOT_NUL);
        }
        this.apiKey = builder.apiKey;
        if (StrUtil.isBlank((CharSequence)builder.apiHost)) {
            builder.apiHost = "https://api.openai.com/";
        }
        this.apiHost = builder.apiHost;
        if (Objects.isNull(builder.keyStrategy)) {
            builder.keyStrategy = new KeyRandomStrategy();
        }
        this.keyStrategy = builder.keyStrategy;
        if (Objects.isNull(builder.authInterceptor)) {
            builder.authInterceptor = new DefaultOpenAiAuthInterceptor();
        }
        this.authInterceptor = builder.authInterceptor;
        this.authInterceptor.setApiKey(this.apiKey);
        this.authInterceptor.setKeyStrategy(this.keyStrategy);
        if (Objects.isNull(builder.okHttpClient)) {
            builder.okHttpClient = this.okHttpClient();
        } else {
            builder.okHttpClient = builder.okHttpClient.newBuilder().addInterceptor((Interceptor)this.authInterceptor).build();
        }
        this.okHttpClient = builder.okHttpClient;
        this.openAiApi = (OpenAiApi)new Retrofit.Builder().baseUrl(this.apiHost).client(this.okHttpClient).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).build().create(OpenAiApi.class);
    }

    private OkHttpClient okHttpClient() {
        if (Objects.isNull(this.authInterceptor)) {
            this.authInterceptor = new DefaultOpenAiAuthInterceptor();
        }
        this.authInterceptor.setApiKey(this.apiKey);
        this.authInterceptor.setKeyStrategy(this.keyStrategy);
        return new OkHttpClient.Builder().addInterceptor((Interceptor)this.authInterceptor).connectTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).build();
    }

    public List<Model> models() {
        Single<ModelResponse> models = this.openAiApi.models();
        return ((ModelResponse)models.blockingGet()).getData();
    }

    public Model model(String id) {
        if (Objects.isNull(id) || "".equals(id)) {
            throw new BaseException(CommonError.PARAM_ERROR);
        }
        Single<Model> model = this.openAiApi.model(id);
        return (Model)model.blockingGet();
    }

    public CompletionResponse completions(Completion completion) {
        Single<CompletionResponse> completions = this.openAiApi.completions(completion);
        return (CompletionResponse)completions.blockingGet();
    }

    public CompletionResponse completions(String question) {
        Completion q = Completion.builder().prompt(question).build();
        Single<CompletionResponse> completions = this.openAiApi.completions(q);
        return (CompletionResponse)completions.blockingGet();
    }

    @Deprecated
    public EditResponse edit(Edit edit) {
        Single<EditResponse> edits = this.openAiApi.edits(edit);
        return (EditResponse)edits.blockingGet();
    }

    public ImageResponse genImages(String prompt) {
        Image image = Image.builder().prompt(prompt).build();
        return this.genImages(image);
    }

    public ImageResponse genImages(Image image) {
        Single<ImageResponse> edits = this.openAiApi.genImages(image);
        return (ImageResponse)edits.blockingGet();
    }

    public List<Item> editImages(java.io.File image, String prompt) {
        ImageEdit imageEdit = ImageEdit.builder().prompt(prompt).build();
        return this.editImages(image, null, imageEdit);
    }

    public List<Item> editImages(java.io.File image, ImageEdit imageEdit) {
        return this.editImages(image, null, imageEdit);
    }

    public List<Item> editImages(java.io.File image, java.io.File mask, ImageEdit imageEdit) {
        this.checkImage(image);
        this.checkImageFormat(image);
        this.checkImageSize(image);
        if (Objects.nonNull(mask)) {
            this.checkImageFormat(image);
            this.checkImageSize(image);
        }
        RequestBody imageBody = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (java.io.File)image);
        MultipartBody.Part imageMultipartBody = MultipartBody.Part.createFormData((String)"image", (String)image.getName(), (RequestBody)imageBody);
        MultipartBody.Part maskMultipartBody = null;
        if (Objects.nonNull(mask)) {
            RequestBody maskBody = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (java.io.File)mask);
            maskMultipartBody = MultipartBody.Part.createFormData((String)"mask", (String)image.getName(), (RequestBody)maskBody);
        }
        HashMap<String, RequestBody> requestBodyMap = new HashMap<String, RequestBody>();
        requestBodyMap.put("prompt", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)imageEdit.getPrompt()));
        requestBodyMap.put("n", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)imageEdit.getN().toString()));
        requestBodyMap.put("size", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)imageEdit.getSize()));
        requestBodyMap.put("response_format", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)imageEdit.getResponseFormat()));
        if (!Objects.isNull(imageEdit.getUser()) && !"".equals(imageEdit.getUser())) {
            requestBodyMap.put("user", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)imageEdit.getUser()));
        }
        Single<ImageResponse> imageResponse = this.openAiApi.editImages(imageMultipartBody, maskMultipartBody, requestBodyMap);
        return ((ImageResponse)imageResponse.blockingGet()).getData();
    }

    public ImageResponse variationsImages(java.io.File image, ImageVariations imageVariations) {
        this.checkImage(image);
        this.checkImageFormat(image);
        this.checkImageSize(image);
        RequestBody imageBody = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (java.io.File)image);
        MultipartBody.Part multipartBody = MultipartBody.Part.createFormData((String)"image", (String)image.getName(), (RequestBody)imageBody);
        HashMap<String, RequestBody> requestBodyMap = new HashMap<String, RequestBody>();
        requestBodyMap.put("n", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)imageVariations.getN().toString()));
        requestBodyMap.put("size", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)imageVariations.getSize()));
        requestBodyMap.put("response_format", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)imageVariations.getResponseFormat()));
        if (!Objects.isNull(imageVariations.getUser()) && !"".equals(imageVariations.getUser())) {
            requestBodyMap.put("user", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)imageVariations.getUser()));
        }
        Single<ImageResponse> variationsImages = this.openAiApi.variationsImages(multipartBody, requestBodyMap);
        return (ImageResponse)variationsImages.blockingGet();
    }

    public ImageResponse variationsImages(java.io.File image) {
        this.checkImage(image);
        this.checkImageFormat(image);
        this.checkImageSize(image);
        ImageVariations imageVariations = ImageVariations.builder().build();
        return this.variationsImages(image, imageVariations);
    }

    private void checkImage(java.io.File image) {
        if (Objects.isNull(image)) {
            log.error("image\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BaseException(CommonError.PARAM_ERROR);
        }
    }

    private void checkImageFormat(java.io.File image) {
        if (!image.getName().endsWith("png") && !image.getName().endsWith("PNG")) {
            log.error("image\u683c\u5f0f\u9519\u8bef");
            throw new BaseException(CommonError.PARAM_ERROR);
        }
    }

    private void checkImageSize(java.io.File image) {
        if (image.length() > 0x400000L) {
            log.error("image\u6700\u5927\u652f\u63014MB");
            throw new BaseException(CommonError.PARAM_ERROR);
        }
    }

    public EmbeddingResponse embeddings(String input) {
        ArrayList<String> inputs = new ArrayList<String>(1);
        inputs.add(input);
        Embedding embedding = Embedding.builder().input(inputs).build();
        return this.embeddings(embedding);
    }

    public EmbeddingResponse embeddings(List<String> input) {
        Embedding embedding = Embedding.builder().input(input).build();
        return this.embeddings(embedding);
    }

    public EmbeddingResponse embeddings(Embedding embedding) {
        Single<EmbeddingResponse> embeddings = this.openAiApi.embeddings(embedding);
        return (EmbeddingResponse)embeddings.blockingGet();
    }

    public List<File> files() {
        Single<OpenAiResponse<File>> files = this.openAiApi.files();
        return ((OpenAiResponse)files.blockingGet()).getData();
    }

    public DeleteResponse deleteFile(String fileId) {
        Single<DeleteResponse> deleteFile = this.openAiApi.deleteFile(fileId);
        return (DeleteResponse)deleteFile.blockingGet();
    }

    public UploadFileResponse uploadFile(String purpose, java.io.File file) {
        RequestBody fileBody = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (java.io.File)file);
        MultipartBody.Part multipartBody = MultipartBody.Part.createFormData((String)"file", (String)file.getName(), (RequestBody)fileBody);
        RequestBody purposeBody = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)purpose);
        Single<UploadFileResponse> uploadFileResponse = this.openAiApi.uploadFile(multipartBody, purposeBody);
        return (UploadFileResponse)uploadFileResponse.blockingGet();
    }

    public UploadFileResponse uploadFile(java.io.File file) {
        return this.uploadFile("fine-tune", file);
    }

    public File retrieveFile(String fileId) {
        Single<File> fileContent = this.openAiApi.retrieveFile(fileId);
        return (File)fileContent.blockingGet();
    }

    public ModerationResponse moderations(String input) {
        ArrayList<String> content = new ArrayList<String>(1);
        content.add(input);
        Moderation moderation = Moderation.builder().input(content).build();
        return this.moderations(moderation);
    }

    public ModerationResponse moderations(List<String> input) {
        Moderation moderation = Moderation.builder().input(input).build();
        return this.moderations(moderation);
    }

    public ModerationResponse moderations(Moderation moderation) {
        Single<ModerationResponse> moderations = this.openAiApi.moderations(moderation);
        return (ModerationResponse)moderations.blockingGet();
    }

    @Deprecated
    public FineTuneResponse fineTune(FineTune fineTune) {
        Single<FineTuneResponse> fineTuneResponse = this.openAiApi.fineTune(fineTune);
        return (FineTuneResponse)fineTuneResponse.blockingGet();
    }

    @Deprecated
    public FineTuneResponse fineTune(String trainingFileId) {
        FineTune fineTune = FineTune.builder().trainingFile(trainingFileId).build();
        return this.fineTune(fineTune);
    }

    @Deprecated
    public List<FineTuneResponse> fineTunes() {
        Single<OpenAiResponse<FineTuneResponse>> fineTunes = this.openAiApi.fineTunes();
        return ((OpenAiResponse)fineTunes.blockingGet()).getData();
    }

    @Deprecated
    public FineTuneResponse retrieveFineTune(String fineTuneId) {
        Single<FineTuneResponse> fineTune = this.openAiApi.retrieveFineTune(fineTuneId);
        return (FineTuneResponse)fineTune.blockingGet();
    }

    @Deprecated
    public FineTuneResponse cancelFineTune(String fineTuneId) {
        Single<FineTuneResponse> fineTune = this.openAiApi.cancelFineTune(fineTuneId);
        return (FineTuneResponse)fineTune.blockingGet();
    }

    @Deprecated
    public List<Event> fineTuneEvents(String fineTuneId) {
        Single<OpenAiResponse<Event>> events = this.openAiApi.fineTuneEvents(fineTuneId);
        return ((OpenAiResponse)events.blockingGet()).getData();
    }

    public FineTuneDeleteResponse deleteFineTuneModel(String model) {
        Single<FineTuneDeleteResponse> delete = this.openAiApi.deleteFineTuneModel(model);
        return (FineTuneDeleteResponse)delete.blockingGet();
    }

    @Deprecated
    public List<Engine> engines() {
        Single<OpenAiResponse<Engine>> engines = this.openAiApi.engines();
        return ((OpenAiResponse)engines.blockingGet()).getData();
    }

    @Deprecated
    public Engine engine(String engineId) {
        Single<Engine> engine = this.openAiApi.engine(engineId);
        return (Engine)engine.blockingGet();
    }

    public <T extends BaseChatCompletion> ChatCompletionResponse chatCompletion(T chatCompletion) {
        if (chatCompletion instanceof ChatCompletion) {
            Single<ChatCompletionResponse> chatCompletionResponse = this.openAiApi.chatCompletion((ChatCompletion)chatCompletion);
            return (ChatCompletionResponse)chatCompletionResponse.blockingGet();
        }
        Single<ChatCompletionResponse> chatCompletionResponse = this.openAiApi.chatCompletionWithPicture((ChatCompletionWithPicture)chatCompletion);
        return (ChatCompletionResponse)chatCompletionResponse.blockingGet();
    }

    public ChatCompletionResponse chatCompletion(List<Message> messages) {
        BaseChatCompletion chatCompletion = ((ChatCompletion.ChatCompletionBuilder)ChatCompletion.builder().messages(messages)).build();
        return this.chatCompletion(chatCompletion);
    }

    public <R extends PluginParam, T> ChatCompletionResponse chatCompletionWithPlugin(ChatCompletion chatCompletion, PluginAbstract<R, T> plugin) {
        if (Objects.isNull(plugin)) {
            return this.chatCompletion(chatCompletion);
        }
        if (CollectionUtil.isEmpty(chatCompletion.getMessages())) {
            throw new BaseException(CommonError.MESSAGE_NOT_NUL);
        }
        List<Message> messages = chatCompletion.getMessages();
        Functions functions = Functions.builder().name(plugin.getFunction()).description(plugin.getDescription()).parameters(plugin.getParameters()).build();
        if (Objects.isNull(chatCompletion.getFunctionCall())) {
            chatCompletion.setFunctionCall("auto");
        }
        chatCompletion.setFunctions(Collections.singletonList(functions));
        ChatCompletionResponse functionCallChatCompletionResponse = this.chatCompletion(chatCompletion);
        ChatChoice chatChoice = functionCallChatCompletionResponse.getChoices().get(0);
        log.debug("\u6784\u9020\u7684\u65b9\u6cd5\u503c\uff1a{}", (Object)chatChoice.getMessage().getFunctionCall());
        PluginParam realFunctionParam = (PluginParam)JSONUtil.toBean((String)chatChoice.getMessage().getFunctionCall().getArguments(), plugin.getR());
        T tq = plugin.func(realFunctionParam);
        FunctionCall functionCall = FunctionCall.builder().arguments(chatChoice.getMessage().getFunctionCall().getArguments()).name(plugin.getFunction()).build();
        messages.add(Message.builder().role(BaseMessage.Role.ASSISTANT).content("function_call").functionCall(functionCall).build());
        messages.add(Message.builder().role(BaseMessage.Role.FUNCTION).name(plugin.getFunction()).content(plugin.content(tq)).build());
        chatCompletion.setFunctionCall(null);
        chatCompletion.setFunctions(null);
        ChatCompletionResponse chatCompletionResponse = this.chatCompletion(chatCompletion);
        log.debug("\u81ea\u5b9a\u4e49\u7684\u65b9\u6cd5\u8fd4\u56de\u503c\uff1a{}", chatCompletionResponse.getChoices());
        return chatCompletionResponse;
    }

    public <R extends PluginParam, T> ChatCompletionResponse chatCompletionWithPlugin(List<Message> messages, PluginAbstract<R, T> plugin) {
        return this.chatCompletionWithPlugin(messages, BaseChatCompletion.Model.GPT_3_5_TURBO_16K_0613.getName(), plugin);
    }

    public <R extends PluginParam, T> ChatCompletionResponse chatCompletionWithPlugin(List<Message> messages, String model, PluginAbstract<R, T> plugin) {
        BaseChatCompletion chatCompletion = ((ChatCompletion.ChatCompletionBuilder)((BaseChatCompletion.BaseChatCompletionBuilder)ChatCompletion.builder().messages(messages)).model(model)).build();
        return this.chatCompletionWithPlugin((ChatCompletion)chatCompletion, plugin);
    }

    public WhisperResponse speechToTextTranscriptions(java.io.File file, Transcriptions transcriptions) {
        RequestBody fileBody = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (java.io.File)file);
        MultipartBody.Part multipartBody = MultipartBody.Part.createFormData((String)"file", (String)file.getName(), (RequestBody)fileBody);
        HashMap<String, RequestBody> requestBodyMap = new HashMap<String, RequestBody>();
        if (StrUtil.isNotBlank((CharSequence)transcriptions.getLanguage())) {
            requestBodyMap.put("language", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)transcriptions.getLanguage()));
        }
        if (StrUtil.isNotBlank((CharSequence)transcriptions.getModel())) {
            requestBodyMap.put("model", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)transcriptions.getModel()));
        }
        if (StrUtil.isNotBlank((CharSequence)transcriptions.getPrompt())) {
            requestBodyMap.put("prompt", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)transcriptions.getPrompt()));
        }
        if (StrUtil.isNotBlank((CharSequence)transcriptions.getResponseFormat())) {
            requestBodyMap.put("responseFormat", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)transcriptions.getResponseFormat()));
        }
        if (Objects.nonNull(transcriptions.getTemperature())) {
            requestBodyMap.put("temperature", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)String.valueOf(transcriptions.getTemperature())));
        }
        Single<WhisperResponse> whisperResponse = this.openAiApi.speechToTextTranscriptions(multipartBody, requestBodyMap);
        return (WhisperResponse)whisperResponse.blockingGet();
    }

    public WhisperResponse speechToTextTranscriptions(java.io.File file) {
        Transcriptions transcriptions = Transcriptions.builder().build();
        return this.speechToTextTranscriptions(file, transcriptions);
    }

    public WhisperResponse speechToTextTranslations(java.io.File file, Translations translations) {
        RequestBody fileBody = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (java.io.File)file);
        MultipartBody.Part multipartBody = MultipartBody.Part.createFormData((String)"file", (String)file.getName(), (RequestBody)fileBody);
        HashMap<String, RequestBody> requestBodyMap = new HashMap<String, RequestBody>(5, 1.0f);
        if (StrUtil.isNotBlank((CharSequence)translations.getModel())) {
            requestBodyMap.put("model", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)translations.getModel()));
        }
        if (StrUtil.isNotBlank((CharSequence)translations.getPrompt())) {
            requestBodyMap.put("prompt", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)translations.getPrompt()));
        }
        if (StrUtil.isNotBlank((CharSequence)translations.getResponseFormat())) {
            requestBodyMap.put("responseFormat", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)translations.getResponseFormat()));
        }
        requestBodyMap.put("temperature", RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)String.valueOf(translations.getTemperature())));
        Single<WhisperResponse> whisperResponse = this.openAiApi.speechToTextTranslations(multipartBody, requestBodyMap);
        return (WhisperResponse)whisperResponse.blockingGet();
    }

    public WhisperResponse speechToTextTranslations(java.io.File file) {
        Translations translations = Translations.builder().build();
        return this.speechToTextTranslations(file, translations);
    }

    private void checkSpeechFileSize(java.io.File file) {
        if (file.length() > 30822400L) {
            log.warn("2023-03-02\u5b98\u65b9\u6587\u6863\u63d0\u793a\uff1a\u6587\u4ef6\u4e0d\u80fd\u8d85\u51fa25MB");
        }
    }

    @Deprecated
    public CreditGrantsResponse creditGrants() {
        Single<CreditGrantsResponse> creditGrants = this.openAiApi.creditGrants();
        return (CreditGrantsResponse)creditGrants.blockingGet();
    }

    public Subscription subscription() {
        Single<Subscription> subscription = this.openAiApi.subscription();
        return (Subscription)subscription.blockingGet();
    }

    public BillingUsage billingUsage(@NotNull LocalDate starDate, @NotNull LocalDate endDate) {
        Single<BillingUsage> billingUsage = this.openAiApi.billingUsage(starDate, endDate);
        return (BillingUsage)billingUsage.blockingGet();
    }

    public FineTuneJobResponse fineTuneJob(FineTuneJob fineTuneJob) {
        Single<FineTuneJobResponse> fineTuneJobResponse = this.openAiApi.fineTuneJob(fineTuneJob);
        return (FineTuneJobResponse)fineTuneJobResponse.blockingGet();
    }

    public FineTuneJobResponse fineTuneJob(String trainingFileId) {
        FineTuneJob fineTuneJob = FineTuneJob.builder().model(FineTuneJob.Model.GPT_3_5_TURBO_1106.getName()).trainingFile(trainingFileId).build();
        return this.fineTuneJob(fineTuneJob);
    }

    public FineTuneJobListResponse<FineTuneJobResponse> fineTuneJobs(String after, Integer limit) {
        Single<FineTuneJobListResponse<FineTuneJobResponse>> fineTuneJobs = this.openAiApi.fineTuneJobs(after, limit);
        return (FineTuneJobListResponse)fineTuneJobs.blockingGet();
    }

    public FineTuneJobResponse retrieveFineTuneJob(String fineTuneJobId) {
        Single<FineTuneJobResponse> fineTuneJob = this.openAiApi.retrieveFineTuneJob(fineTuneJobId);
        return (FineTuneJobResponse)fineTuneJob.blockingGet();
    }

    public FineTuneJobResponse cancelFineTuneJob(String fineTuneJobId) {
        Single<FineTuneJobResponse> fineTuneJob = this.openAiApi.cancelFineTuneJob(fineTuneJobId);
        return (FineTuneJobResponse)fineTuneJob.blockingGet();
    }

    public FineTuneJobListResponse<FineTuneJobEvent> fineTuneJobEvents(String fineTuneJobId, String after, Integer limit) {
        Single<FineTuneJobListResponse<FineTuneJobEvent>> events = this.openAiApi.fineTuneJobEvents(fineTuneJobId, after, limit);
        return (FineTuneJobListResponse)events.blockingGet();
    }

    public void textToSpeech(TextToSpeech textToSpeech, Callback callback) {
        Call<ResponseBody> responseBody = this.openAiApi.textToSpeech(textToSpeech);
        responseBody.enqueue(callback);
    }

    public ResponseBody textToSpeech(TextToSpeech textToSpeech) throws IOException {
        Call<ResponseBody> responseBody = this.openAiApi.textToSpeech(textToSpeech);
        return (ResponseBody)responseBody.execute().body();
    }

    public AssistantResponse assistant(Assistant assistant) {
        Single<AssistantResponse> assistantResponse = this.openAiApi.assistant(assistant);
        return (AssistantResponse)assistantResponse.blockingGet();
    }

    public AssistantResponse retrieveAssistant(String assistantId) {
        Single<AssistantResponse> assistant = this.openAiApi.retrieveAssistant(assistantId);
        return (AssistantResponse)assistant.blockingGet();
    }

    public AssistantResponse modifyAssistant(String assistantId, Assistant assistant) {
        Single<AssistantResponse> assistantResponse = this.openAiApi.modifyAssistant(assistantId, assistant);
        return (AssistantResponse)assistantResponse.blockingGet();
    }

    public DeleteResponse deleteAssistant(String assistantId) {
        Single<DeleteResponse> deleteAssistant = this.openAiApi.deleteAssistant(assistantId);
        return (DeleteResponse)deleteAssistant.blockingGet();
    }

    public AssistantListResponse<AssistantResponse> assistants(PageRequest pageRequest) {
        Single<AssistantListResponse<AssistantResponse>> assistants = this.openAiApi.assistants(pageRequest.getLimit(), pageRequest.getOrder(), pageRequest.getBefore(), pageRequest.getAfter());
        return (AssistantListResponse)assistants.blockingGet();
    }

    public AssistantFileResponse assistantFile(String assistantId, AssistantFile assistantFile) {
        Single<AssistantFileResponse> assistantFileResponse = this.openAiApi.assistantFile(assistantId, assistantFile);
        return (AssistantFileResponse)assistantFileResponse.blockingGet();
    }

    public AssistantFileResponse retrieveAssistantFile(String assistantId, String fileId) {
        Single<AssistantFileResponse> assistantFileResponse = this.openAiApi.retrieveAssistantFile(assistantId, fileId);
        return (AssistantFileResponse)assistantFileResponse.blockingGet();
    }

    public DeleteResponse deleteAssistantFile(String assistantId, String fileId) {
        Single<DeleteResponse> deleteResponse = this.openAiApi.deleteAssistantFile(assistantId, fileId);
        return (DeleteResponse)deleteResponse.blockingGet();
    }

    public AssistantListResponse<AssistantFileResponse> assistantFiles(String assistantId, PageRequest pageRequest) {
        pageRequest = Optional.ofNullable(pageRequest).orElse(this.getPageRequest());
        Single<AssistantListResponse<AssistantFileResponse>> deleteResponse = this.openAiApi.assistantFiles(assistantId, pageRequest.getLimit(), pageRequest.getOrder(), pageRequest.getBefore(), pageRequest.getAfter());
        return (AssistantListResponse)deleteResponse.blockingGet();
    }

    public ThreadResponse thread(Thread thread) {
        return (ThreadResponse)this.openAiApi.thread(thread).blockingGet();
    }

    public ThreadResponse retrieveThread(String threadId) {
        return (ThreadResponse)this.openAiApi.retrieveThread(threadId).blockingGet();
    }

    public ThreadResponse modifyThread(String threadId, ModifyThread thread) {
        return (ThreadResponse)this.openAiApi.modifyThread(threadId, thread).blockingGet();
    }

    public DeleteResponse deleteThread(String threadId) {
        return (DeleteResponse)this.openAiApi.deleteThread(threadId).blockingGet();
    }

    public MessageResponse message(String threadId, ThreadMessage message) {
        return (MessageResponse)this.openAiApi.message(threadId, message).blockingGet();
    }

    public MessageResponse retrieveMessage(String threadId, String messageId) {
        return (MessageResponse)this.openAiApi.retrieveMessage(threadId, messageId).blockingGet();
    }

    public MessageResponse modifyMessage(String threadId, String messageId, ModifyMessage message) {
        return (MessageResponse)this.openAiApi.modifyMessage(threadId, messageId, message).blockingGet();
    }

    public AssistantListResponse<MessageResponse> messages(String threadId, PageRequest pageRequest) {
        pageRequest = Optional.ofNullable(pageRequest).orElse(this.getPageRequest());
        return (AssistantListResponse)this.openAiApi.messages(threadId, pageRequest.getLimit(), pageRequest.getOrder(), pageRequest.getBefore(), pageRequest.getAfter()).blockingGet();
    }

    public MessageFileResponse retrieveMessageFile(String threadId, String messageId, String fileId) {
        return (MessageFileResponse)this.openAiApi.retrieveMessageFile(threadId, messageId, fileId).blockingGet();
    }

    public AssistantListResponse<MessageFileResponse> messageFiles(String threadId, String messageId, PageRequest pageRequest) {
        pageRequest = Optional.ofNullable(pageRequest).orElse(this.getPageRequest());
        return (AssistantListResponse)this.openAiApi.messageFiles(threadId, messageId, pageRequest.getLimit(), pageRequest.getOrder(), pageRequest.getBefore(), pageRequest.getAfter()).blockingGet();
    }

    public RunResponse run(String threadId, Run run) {
        return (RunResponse)this.openAiApi.run(threadId, run).blockingGet();
    }

    public RunResponse retrieveRun(String threadId, String runId) {
        return (RunResponse)this.openAiApi.retrieveRun(threadId, runId).blockingGet();
    }

    public RunResponse modifyRun(String threadId, String runId, ModifyRun run) {
        return (RunResponse)this.openAiApi.modifyRun(threadId, runId, run).blockingGet();
    }

    public AssistantListResponse<RunResponse> runs(String threadId, PageRequest pageRequest) {
        pageRequest = Optional.ofNullable(pageRequest).orElse(this.getPageRequest());
        return (AssistantListResponse)this.openAiApi.runs(threadId, pageRequest.getLimit(), pageRequest.getOrder(), pageRequest.getBefore(), pageRequest.getAfter()).blockingGet();
    }

    public RunResponse submitToolOutputs(String threadId, String runId, ToolOutputBody toolOutputs) {
        return (RunResponse)this.openAiApi.submitToolOutputs(threadId, runId, toolOutputs).blockingGet();
    }

    public RunResponse cancelRun(String threadId, String runId) {
        return (RunResponse)this.openAiApi.cancelRun(threadId, runId).blockingGet();
    }

    public RunResponse threadRun(ThreadRun threadRun) {
        return (RunResponse)this.openAiApi.threadRun(threadRun).blockingGet();
    }

    public RunStepResponse retrieveRunStep(String threadId, String runId, String stepId) {
        if (StrUtil.isBlank((CharSequence)stepId)) {
            log.error("step id\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BaseException(CommonError.PARAM_ERROR);
        }
        return (RunStepResponse)this.openAiApi.retrieveRunStep(threadId, runId, stepId).blockingGet();
    }

    public AssistantListResponse<RunStepResponse> runSteps(String threadId, String runId, PageRequest pageRequest) {
        pageRequest = Optional.ofNullable(pageRequest).orElse(this.getPageRequest());
        return (AssistantListResponse)this.openAiApi.runSteps(threadId, runId, pageRequest.getLimit(), pageRequest.getOrder(), pageRequest.getBefore(), pageRequest.getAfter()).blockingGet();
    }

    @NotNull
    public List<String> getApiKey() {
        return this.apiKey;
    }

    public String getApiHost() {
        return this.apiHost;
    }

    public OpenAiApi getOpenAiApi() {
        return this.openAiApi;
    }

    public OkHttpClient getOkHttpClient() {
        return this.okHttpClient;
    }

    public KeyStrategyFunction<List<String>, String> getKeyStrategy() {
        return this.keyStrategy;
    }

    public OpenAiAuthInterceptor getAuthInterceptor() {
        return this.authInterceptor;
    }

    public PageRequest getPageRequest() {
        return this.pageRequest;
    }

    public static final class Builder {
        @NotNull
        private List<String> apiKey;
        private String apiHost;
        private OkHttpClient okHttpClient;
        private KeyStrategyFunction keyStrategy;
        private OpenAiAuthInterceptor authInterceptor;

        public Builder apiHost(String val) {
            this.apiHost = val;
            return this;
        }

        public Builder apiKey(@NotNull List<String> val) {
            this.apiKey = val;
            return this;
        }

        public Builder keyStrategy(KeyStrategyFunction val) {
            this.keyStrategy = val;
            return this;
        }

        public Builder okHttpClient(OkHttpClient val) {
            this.okHttpClient = val;
            return this;
        }

        public Builder authInterceptor(OpenAiAuthInterceptor val) {
            this.authInterceptor = val;
            return this;
        }

        public OpenAiClient build() {
            return new OpenAiClient(this);
        }
    }
}

