/*
 * Decompiled with CFR 0.152.
 */
package com.ullink.slack.simpleslackapi;

import com.ullink.slack.simpleslackapi.SlackUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class SlackChannel {
    private String id;
    private String name;
    private String topic;
    private String purpose;
    private boolean direct;
    private boolean isMember;
    private boolean isArchived;
    private final transient Set<SlackUser> members;

    public SlackChannel(String id, String name, String topic, String purpose, boolean direct, boolean isMember, boolean isArchived) {
        this.id = id;
        this.name = name;
        this.topic = topic;
        this.purpose = purpose;
        this.direct = direct;
        this.isMember = isMember;
        this.isArchived = isArchived;
        this.members = new HashSet<SlackUser>();
    }

    public SlackChannel() {
        this.members = new HashSet<SlackUser>();
    }

    public void addUser(SlackUser user) {
        this.members.add(user);
    }

    void removeUser(SlackUser user) {
        this.members.remove(user);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Collection<SlackUser> getMembers() {
        return new ArrayList<SlackUser>(this.members);
    }

    public String getTopic() {
        return this.topic;
    }

    public String toString() {
        return "SlackChannel{topic='" + this.topic + '\'' + ", purpose='" + this.purpose + '\'' + ", id='" + this.id + '\'' + ", name='" + this.name + '\'' + '}';
    }

    public String getPurpose() {
        return this.purpose;
    }

    public boolean isDirect() {
        return this.direct;
    }

    public boolean isMember() {
        return this.isMember;
    }

    public boolean isArchived() {
        return this.isArchived;
    }

    public SlackChannelType getType() {
        if (this.isDirect()) {
            return SlackChannelType.INSTANT_MESSAGING;
        }
        if (this.id.startsWith("G")) {
            return SlackChannelType.PRIVATE_GROUP;
        }
        return SlackChannelType.PUBLIC_CHANNEL;
    }

    public static SlackChannelBuilder builder() {
        return new SlackChannelBuilder();
    }

    public SlackChannelBuilder toBuilder() {
        SlackChannelBuilder builder = new SlackChannelBuilder().id(this.id).name(this.name).topic(this.topic).purpose(this.purpose).direct(this.direct).isMember(this.isMember).isArchived(this.isArchived);
        if (this.members != null) {
            builder.members(this.members);
        }
        return builder;
    }

    public SlackChannel(String id, String name, String topic, String purpose, boolean direct, boolean isMember, boolean isArchived, Set<SlackUser> members) {
        this.id = id;
        this.name = name;
        this.topic = topic;
        this.purpose = purpose;
        this.direct = direct;
        this.isMember = isMember;
        this.isArchived = isArchived;
        this.members = members;
    }

    public static class SlackChannelBuilder {
        private String id;
        private String name;
        private String topic;
        private String purpose;
        private boolean direct;
        private boolean isMember;
        private boolean isArchived;
        private ArrayList<SlackUser> members;

        SlackChannelBuilder() {
        }

        public SlackChannelBuilder id(String id) {
            this.id = id;
            return this;
        }

        public SlackChannelBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SlackChannelBuilder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public SlackChannelBuilder purpose(String purpose) {
            this.purpose = purpose;
            return this;
        }

        public SlackChannelBuilder direct(boolean direct) {
            this.direct = direct;
            return this;
        }

        public SlackChannelBuilder isMember(boolean isMember) {
            this.isMember = isMember;
            return this;
        }

        public SlackChannelBuilder isArchived(boolean isArchived) {
            this.isArchived = isArchived;
            return this;
        }

        public SlackChannelBuilder member(SlackUser member) {
            if (this.members == null) {
                this.members = new ArrayList();
            }
            this.members.add(member);
            return this;
        }

        public SlackChannelBuilder members(Collection<? extends SlackUser> members) {
            if (this.members == null) {
                this.members = new ArrayList();
            }
            this.members.addAll(members);
            return this;
        }

        public SlackChannelBuilder clearMembers() {
            if (this.members != null) {
                this.members.clear();
            }
            return this;
        }

        public SlackChannel build() {
            Set<Object> members;
            switch (this.members == null ? 0 : this.members.size()) {
                case 0: {
                    members = Collections.emptySet();
                    break;
                }
                case 1: {
                    members = Collections.singleton(this.members.get(0));
                    break;
                }
                default: {
                    members = new LinkedHashSet(this.members.size() < 0x40000000 ? 1 + this.members.size() + (this.members.size() - 3) / 3 : Integer.MAX_VALUE);
                    members.addAll(this.members);
                    members = Collections.unmodifiableSet(members);
                }
            }
            return new SlackChannel(this.id, this.name, this.topic, this.purpose, this.direct, this.isMember, this.isArchived, members);
        }

        public String toString() {
            return "SlackChannel.SlackChannelBuilder(id=" + this.id + ", name=" + this.name + ", topic=" + this.topic + ", purpose=" + this.purpose + ", direct=" + this.direct + ", isMember=" + this.isMember + ", isArchived=" + this.isArchived + ", members=" + this.members + ")";
        }
    }

    public static enum SlackChannelType {
        PUBLIC_CHANNEL,
        PRIVATE_GROUP,
        INSTANT_MESSAGING;

    }
}

