/*
 * Decompiled with CFR 0.152.
 */
package com.udojava.evalex;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Expression {
    public static final BigDecimal PI = new BigDecimal("3.1415926535897932384626433832795028841971693993751058209749445923078164062862089986280348253421170679");
    private MathContext mc = null;
    private String expression = null;
    private List<String> rpn = null;
    private Map<String, Operator> operators = new HashMap<String, Operator>();
    private Map<String, Function> functions = new HashMap<String, Function>();
    private Map<String, BigDecimal> variables = new HashMap<String, BigDecimal>();
    private static final char decimalSeparator = '.';
    private static final char minusSign = '-';
    private static final BigDecimal PARAMS_START = new BigDecimal(0);

    public Expression(String expression) {
        this(expression, MathContext.DECIMAL32);
    }

    public Expression(String expression, MathContext defaultMathContext) {
        this.mc = defaultMathContext;
        this.expression = expression;
        this.addOperator(new Operator("+", 20, true){

            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                return v1.add(v2, Expression.this.mc);
            }
        });
        this.addOperator(new Operator("-", 20, true){

            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                return v1.subtract(v2, Expression.this.mc);
            }
        });
        this.addOperator(new Operator("*", 30, true){

            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                return v1.multiply(v2, Expression.this.mc);
            }
        });
        this.addOperator(new Operator("/", 30, true){

            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                return v1.divide(v2, Expression.this.mc);
            }
        });
        this.addOperator(new Operator("%", 30, true){

            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                return v1.remainder(v2, Expression.this.mc);
            }
        });
        this.addOperator(new Operator("^", 40, false){

            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                int signOf2 = v2.signum();
                double dn1 = v1.doubleValue();
                v2 = v2.multiply(new BigDecimal(signOf2));
                BigDecimal remainderOf2 = v2.remainder(BigDecimal.ONE);
                BigDecimal n2IntPart = v2.subtract(remainderOf2);
                BigDecimal intPow = v1.pow(n2IntPart.intValueExact(), Expression.this.mc);
                BigDecimal doublePow = new BigDecimal(Math.pow(dn1, remainderOf2.doubleValue()));
                BigDecimal result = intPow.multiply(doublePow, Expression.this.mc);
                if (signOf2 == -1) {
                    result = BigDecimal.ONE.divide(result, Expression.this.mc.getPrecision(), RoundingMode.HALF_UP);
                }
                return result;
            }
        });
        this.addOperator(new Operator("&&", 4, false){

            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                boolean b1 = !v1.equals(BigDecimal.ZERO);
                boolean b2 = !v2.equals(BigDecimal.ZERO);
                return b1 && b2 ? BigDecimal.ONE : BigDecimal.ZERO;
            }
        });
        this.addOperator(new Operator("||", 2, false){

            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                boolean b1 = !v1.equals(BigDecimal.ZERO);
                boolean b2 = !v2.equals(BigDecimal.ZERO);
                return b1 || b2 ? BigDecimal.ONE : BigDecimal.ZERO;
            }
        });
        this.addOperator(new Operator(">", 10, false){

            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                return v1.compareTo(v2) == 1 ? BigDecimal.ONE : BigDecimal.ZERO;
            }
        });
        this.addOperator(new Operator(">=", 10, false){

            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                return v1.compareTo(v2) >= 0 ? BigDecimal.ONE : BigDecimal.ZERO;
            }
        });
        this.addOperator(new Operator("<", 10, false){

            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                return v1.compareTo(v2) == -1 ? BigDecimal.ONE : BigDecimal.ZERO;
            }
        });
        this.addOperator(new Operator("<=", 10, false){

            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                return v1.compareTo(v2) <= 0 ? BigDecimal.ONE : BigDecimal.ZERO;
            }
        });
        this.addOperator(new Operator("=", 7, false){

            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                return v1.compareTo(v2) == 0 ? BigDecimal.ONE : BigDecimal.ZERO;
            }
        });
        this.addOperator(new Operator("==", 7, false){

            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                return ((Operator)Expression.this.operators.get("=")).eval(v1, v2);
            }
        });
        this.addOperator(new Operator("!=", 7, false){

            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                return v1.compareTo(v2) != 0 ? BigDecimal.ONE : BigDecimal.ZERO;
            }
        });
        this.addOperator(new Operator("<>", 7, false){

            public BigDecimal eval(BigDecimal v1, BigDecimal v2) {
                return ((Operator)Expression.this.operators.get("!=")).eval(v1, v2);
            }
        });
        this.addFunction(new Function("NOT", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                boolean zero = parameters.get(0).compareTo(BigDecimal.ZERO) == 0;
                return zero ? BigDecimal.ONE : BigDecimal.ZERO;
            }
        });
        this.addFunction(new Function("IF", 3){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                boolean isTrue = !parameters.get(0).equals(BigDecimal.ZERO);
                return isTrue ? parameters.get(1) : parameters.get(2);
            }
        });
        this.addFunction(new Function("RANDOM", 0){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                double d = Math.random();
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("SIN", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                double d = Math.sin(Math.toRadians(parameters.get(0).doubleValue()));
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("COS", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                double d = Math.cos(Math.toRadians(parameters.get(0).doubleValue()));
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("TAN", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                double d = Math.tan(Math.toRadians(parameters.get(0).doubleValue()));
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("ASIN", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                double d = Math.toDegrees(Math.asin(parameters.get(0).doubleValue()));
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("ACOS", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                double d = Math.toDegrees(Math.acos(parameters.get(0).doubleValue()));
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("ATAN", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                double d = Math.toDegrees(Math.atan(parameters.get(0).doubleValue()));
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("SINH", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                double d = Math.sinh(parameters.get(0).doubleValue());
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("COSH", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                double d = Math.cosh(parameters.get(0).doubleValue());
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("TANH", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                double d = Math.tanh(parameters.get(0).doubleValue());
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("RAD", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                double d = Math.toRadians(parameters.get(0).doubleValue());
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("DEG", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                double d = Math.toDegrees(parameters.get(0).doubleValue());
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("MAX", -1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                if (parameters.size() == 0) {
                    throw new ExpressionException("MAX requires at least one parameter");
                }
                BigDecimal max = null;
                for (BigDecimal parameter : parameters) {
                    if (max != null && parameter.compareTo(max) <= 0) continue;
                    max = parameter;
                }
                return max;
            }
        });
        this.addFunction(new Function("MIN", -1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                if (parameters.size() == 0) {
                    throw new ExpressionException("MIN requires at least one parameter");
                }
                BigDecimal min = null;
                for (BigDecimal parameter : parameters) {
                    if (min != null && parameter.compareTo(min) >= 0) continue;
                    min = parameter;
                }
                return min;
            }
        });
        this.addFunction(new Function("ABS", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                return parameters.get(0).abs(Expression.this.mc);
            }
        });
        this.addFunction(new Function("LOG", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                double d = Math.log(parameters.get(0).doubleValue());
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("LOG10", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                double d = Math.log10(parameters.get(0).doubleValue());
                return new BigDecimal(d, Expression.this.mc);
            }
        });
        this.addFunction(new Function("ROUND", 2){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                BigDecimal toRound = parameters.get(0);
                int precision = parameters.get(1).intValue();
                return toRound.setScale(precision, Expression.this.mc.getRoundingMode());
            }
        });
        this.addFunction(new Function("FLOOR", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                BigDecimal toRound = parameters.get(0);
                return toRound.setScale(0, RoundingMode.FLOOR);
            }
        });
        this.addFunction(new Function("CEILING", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                BigDecimal toRound = parameters.get(0);
                return toRound.setScale(0, RoundingMode.CEILING);
            }
        });
        this.addFunction(new Function("SQRT", 1){

            @Override
            public BigDecimal eval(List<BigDecimal> parameters) {
                BigInteger ixPrev;
                BigDecimal x = parameters.get(0);
                if (x.compareTo(BigDecimal.ZERO) == 0) {
                    return new BigDecimal(0);
                }
                if (x.signum() < 0) {
                    throw new ExpressionException("Argument to SQRT() function must not be negative");
                }
                BigInteger n = x.movePointRight(Expression.this.mc.getPrecision() << 1).toBigInteger();
                int bits = n.bitLength() + 1 >> 1;
                BigInteger ix = n.shiftRight(bits);
                do {
                    ixPrev = ix;
                    ix = ix.add(n.divide(ix)).shiftRight(1);
                    Thread.yield();
                } while (ix.compareTo(ixPrev) != 0);
                return new BigDecimal(ix, Expression.this.mc.getPrecision());
            }
        });
        this.variables.put("PI", PI);
        this.variables.put("TRUE", BigDecimal.ONE);
        this.variables.put("FALSE", BigDecimal.ZERO);
    }

    private boolean isNumber(String st) {
        if (st.charAt(0) == '-' && st.length() == 1) {
            return false;
        }
        for (char ch : st.toCharArray()) {
            if (Character.isDigit(ch) || ch == '-' || ch == '.') continue;
            return false;
        }
        return true;
    }

    private List<String> shuntingYard(String expression) {
        ArrayList<String> outputQueue = new ArrayList<String>();
        Stack<String> stack = new Stack<String>();
        Tokenizer tokenizer = new Tokenizer(expression);
        String lastFunction = null;
        String previousToken = null;
        while (tokenizer.hasNext()) {
            String token = tokenizer.next();
            if (this.isNumber(token)) {
                outputQueue.add(token);
            } else if (this.variables.containsKey(token)) {
                outputQueue.add(token);
            } else if (this.functions.containsKey(token.toUpperCase(Locale.ROOT))) {
                stack.push(token);
                lastFunction = token;
            } else if (Character.isLetter(token.charAt(0))) {
                stack.push(token);
            } else if (",".equals(token)) {
                while (!stack.isEmpty() && !"(".equals(stack.peek())) {
                    outputQueue.add((String)stack.pop());
                }
                if (stack.isEmpty()) {
                    throw new ExpressionException("Parse error for function '" + lastFunction + "'");
                }
            } else if (this.operators.containsKey(token)) {
                String token2;
                Operator o1 = this.operators.get(token);
                String string = token2 = stack.isEmpty() ? null : (String)stack.peek();
                while (this.operators.containsKey(token2) && (o1.isLeftAssoc() && o1.getPrecedence() <= this.operators.get(token2).getPrecedence() || o1.getPrecedence() < this.operators.get(token2).getPrecedence())) {
                    outputQueue.add((String)stack.pop());
                    token2 = stack.isEmpty() ? null : (String)stack.peek();
                }
                stack.push(token);
            } else if ("(".equals(token)) {
                if (previousToken != null) {
                    if (this.isNumber(previousToken)) {
                        throw new ExpressionException("Missing operator at character position " + tokenizer.getPos());
                    }
                    if (this.functions.containsKey(previousToken.toUpperCase(Locale.ROOT))) {
                        outputQueue.add(token);
                    }
                }
                stack.push(token);
            } else if (")".equals(token)) {
                while (!stack.isEmpty() && !"(".equals(stack.peek())) {
                    outputQueue.add((String)stack.pop());
                }
                if (stack.isEmpty()) {
                    throw new RuntimeException("Mismatched parentheses");
                }
                stack.pop();
                if (!stack.isEmpty() && this.functions.containsKey(((String)stack.peek()).toUpperCase(Locale.ROOT))) {
                    outputQueue.add((String)stack.pop());
                }
            }
            previousToken = token;
        }
        while (!stack.isEmpty()) {
            String element = (String)stack.pop();
            if ("(".equals(element) || ")".equals(element)) {
                throw new RuntimeException("Mismatched parentheses");
            }
            if (!this.operators.containsKey(element)) {
                throw new RuntimeException("Unknown operator or function: " + element);
            }
            outputQueue.add(element);
        }
        return outputQueue;
    }

    public BigDecimal eval() {
        Stack<BigDecimal> stack = new Stack<BigDecimal>();
        for (String token : this.getRPN()) {
            if (this.operators.containsKey(token)) {
                BigDecimal v1 = (BigDecimal)stack.pop();
                BigDecimal v2 = (BigDecimal)stack.pop();
                stack.push(this.operators.get(token).eval(v2, v1));
                continue;
            }
            if (this.variables.containsKey(token)) {
                stack.push(this.variables.get(token).round(this.mc));
                continue;
            }
            if (this.functions.containsKey(token.toUpperCase(Locale.ROOT))) {
                Function f = this.functions.get(token.toUpperCase(Locale.ROOT));
                ArrayList<BigDecimal> p = new ArrayList<BigDecimal>(!f.numParamsVaries() ? f.getNumParams() : 0);
                while (!stack.isEmpty() && stack.peek() != PARAMS_START) {
                    p.add(0, (BigDecimal)stack.pop());
                }
                if (stack.peek() == PARAMS_START) {
                    stack.pop();
                }
                if (!f.numParamsVaries() && p.size() != f.getNumParams()) {
                    throw new ExpressionException("Function " + token + " expected " + f.getNumParams() + " parameters, got " + p.size());
                }
                BigDecimal fResult = f.eval(p);
                stack.push(fResult);
                continue;
            }
            if ("(".equals(token)) {
                stack.push(PARAMS_START);
                continue;
            }
            stack.push(new BigDecimal(token, this.mc));
        }
        return ((BigDecimal)stack.pop()).stripTrailingZeros();
    }

    public Expression setPrecision(int precision) {
        this.mc = new MathContext(precision);
        return this;
    }

    public Expression setRoundingMode(RoundingMode roundingMode) {
        this.mc = new MathContext(this.mc.getPrecision(), roundingMode);
        return this;
    }

    public Operator addOperator(Operator operator) {
        return this.operators.put(operator.getOper(), operator);
    }

    public Function addFunction(Function function) {
        return this.functions.put(function.getName(), function);
    }

    public Expression setVariable(String variable, BigDecimal value) {
        this.variables.put(variable, value);
        return this;
    }

    public Expression setVariable(String variable, String value) {
        if (this.isNumber(value)) {
            this.variables.put(variable, new BigDecimal(value));
        } else {
            this.expression = this.expression.replaceAll("\\b" + variable + "\\b", "(" + value + ")");
            this.rpn = null;
        }
        return this;
    }

    public Expression with(String variable, BigDecimal value) {
        return this.setVariable(variable, value);
    }

    public Expression and(String variable, String value) {
        return this.setVariable(variable, value);
    }

    public Expression and(String variable, BigDecimal value) {
        return this.setVariable(variable, value);
    }

    public Expression with(String variable, String value) {
        return this.setVariable(variable, value);
    }

    public Iterator<String> getExpressionTokenizer() {
        return new Tokenizer(this.expression);
    }

    private List<String> getRPN() {
        if (this.rpn == null) {
            this.rpn = this.shuntingYard(this.expression);
            this.validate(this.rpn);
        }
        return this.rpn;
    }

    private void validate(List<String> rpn) {
        int counter = 0;
        Stack<Integer> params = new Stack<Integer>();
        for (String token : rpn) {
            if ("(".equals(token)) {
                if (!params.isEmpty()) {
                    params.set(params.size() - 1, (Integer)params.peek() + 1);
                }
                params.push(0);
            } else if (!params.isEmpty()) {
                if (this.functions.containsKey(token.toUpperCase(Locale.ROOT))) {
                    counter -= (Integer)params.pop() + 1;
                } else {
                    params.set(params.size() - 1, (Integer)params.peek() + 1);
                }
            } else if (this.operators.containsKey(token)) {
                counter -= 2;
            }
            if (counter < 0) {
                throw new ExpressionException("Too many operators or functions at: " + token);
            }
            ++counter;
        }
        if (counter > 1) {
            throw new ExpressionException("Too many numbers or variables");
        }
        if (counter < 1) {
            throw new ExpressionException("Empty expression");
        }
    }

    public String toRPN() {
        StringBuilder result = new StringBuilder();
        for (String st : this.getRPN()) {
            if (result.length() != 0) {
                result.append(" ");
            }
            result.append(st);
        }
        return result.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Tokenizer
    implements Iterator<String> {
        private int pos = 0;
        private String input;
        private String previousToken;

        public Tokenizer(String input) {
            this.input = input.trim();
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.input.length();
        }

        private char peekNextChar() {
            if (this.pos < this.input.length() - 1) {
                return this.input.charAt(this.pos + 1);
            }
            return '\u0000';
        }

        @Override
        public String next() {
            StringBuilder token = new StringBuilder();
            if (this.pos >= this.input.length()) {
                this.previousToken = null;
                return null;
            }
            char ch = this.input.charAt(this.pos);
            while (Character.isWhitespace(ch) && this.pos < this.input.length()) {
                ch = this.input.charAt(++this.pos);
            }
            if (Character.isDigit(ch)) {
                while ((Character.isDigit(ch) || ch == '.') && this.pos < this.input.length()) {
                    token.append(this.input.charAt(this.pos++));
                    ch = this.pos == this.input.length() ? (char)'\u0000' : this.input.charAt(this.pos);
                }
            } else if (ch == '-' && Character.isDigit(this.peekNextChar()) && ("(".equals(this.previousToken) || ",".equals(this.previousToken) || this.previousToken == null || Expression.this.operators.containsKey(this.previousToken))) {
                token.append('-');
                ++this.pos;
                token.append(this.next());
            } else if (Character.isLetter(ch) || ch == '_') {
                while ((Character.isLetter(ch) || Character.isDigit(ch) || ch == '_') && this.pos < this.input.length()) {
                    token.append(this.input.charAt(this.pos++));
                    ch = this.pos == this.input.length() ? (char)'\u0000' : this.input.charAt(this.pos);
                }
            } else if (ch == '(' || ch == ')' || ch == ',') {
                token.append(ch);
                ++this.pos;
            } else {
                while (!(Character.isLetter(ch) || Character.isDigit(ch) || ch == '_' || Character.isWhitespace(ch) || ch == '(' || ch == ')' || ch == ',' || this.pos >= this.input.length())) {
                    token.append(this.input.charAt(this.pos));
                    ++this.pos;
                    ch = this.pos == this.input.length() ? (char)'\u0000' : this.input.charAt(this.pos);
                    if (ch != '-') continue;
                }
                if (!Expression.this.operators.containsKey(token.toString())) {
                    throw new ExpressionException("Unknown operator '" + token + "' at position " + (this.pos - token.length() + 1));
                }
            }
            this.previousToken = token.toString();
            return this.previousToken;
        }

        @Override
        public void remove() {
            throw new ExpressionException("remove() not supported");
        }

        public int getPos() {
            return this.pos;
        }
    }

    public abstract class Operator {
        private String oper;
        private int precedence;
        private boolean leftAssoc;

        public Operator(String oper, int precedence, boolean leftAssoc) {
            this.oper = oper;
            this.precedence = precedence;
            this.leftAssoc = leftAssoc;
        }

        public String getOper() {
            return this.oper;
        }

        public int getPrecedence() {
            return this.precedence;
        }

        public boolean isLeftAssoc() {
            return this.leftAssoc;
        }

        public abstract BigDecimal eval(BigDecimal var1, BigDecimal var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class Function {
        private String name;
        private int numParams;

        public Function(String name, int numParams) {
            this.name = name.toUpperCase(Locale.ROOT);
            this.numParams = numParams;
        }

        public String getName() {
            return this.name;
        }

        public int getNumParams() {
            return this.numParams;
        }

        public boolean numParamsVaries() {
            return this.numParams < 0;
        }

        public abstract BigDecimal eval(List<BigDecimal> var1);
    }

    public static class ExpressionException
    extends RuntimeException {
        private static final long serialVersionUID = 1118142866870779047L;

        public ExpressionException(String message) {
            super(message);
        }
    }
}

