/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html;

import java.util.LinkedHashSet;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import org.owasp.html.JoinedAttributePolicy;
import org.owasp.html.TCB;

@TCB
public interface AttributePolicy {
    public static final AttributePolicy IDENTITY_ATTRIBUTE_POLICY = new AttributePolicy(){

        public String apply(String elementName, String attributeName, String value) {
            return value;
        }
    };
    public static final AttributePolicy REJECT_ALL_ATTRIBUTE_POLICY = new AttributePolicy(){

        @Nullable
        public String apply(String elementName, String attributeName, String value) {
            return null;
        }
    };

    @Nullable
    public String apply(String var1, String var2, String var3);

    public static final class Util {
        @CheckReturnValue
        public static final AttributePolicy join(AttributePolicy ... policies) {
            LinkedHashSet<AttributePolicy> uniq = new LinkedHashSet<AttributePolicy>();
            for (AttributePolicy p : policies) {
                if (p instanceof JoinedAttributePolicy) {
                    uniq.addAll(((JoinedAttributePolicy)p).policies);
                    continue;
                }
                if (p == null) continue;
                uniq.add(p);
            }
            if (uniq.contains(REJECT_ALL_ATTRIBUTE_POLICY)) {
                return REJECT_ALL_ATTRIBUTE_POLICY;
            }
            uniq.remove(IDENTITY_ATTRIBUTE_POLICY);
            switch (uniq.size()) {
                case 0: {
                    return IDENTITY_ATTRIBUTE_POLICY;
                }
                case 1: {
                    return (AttributePolicy)uniq.iterator().next();
                }
            }
            return new JoinedAttributePolicy(uniq);
        }
    }
}

