/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.trigger.manual;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.watcher.trigger.TriggerEvent;
import org.elasticsearch.xpack.watcher.trigger.TriggerService;

public class ManualTriggerEvent
extends TriggerEvent {
    private final TriggerEvent triggerEvent;

    public ManualTriggerEvent(String jobName, TriggerEvent triggerEvent) {
        super(jobName, triggerEvent.triggeredTime());
        this.triggerEvent = triggerEvent;
        this.data.putAll(triggerEvent.data());
    }

    @Override
    public String type() {
        return "manual";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(this.triggerEvent.type(), this.triggerEvent, params);
        return builder.endObject();
    }

    @Override
    public void recordDataXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("manual");
        this.triggerEvent.recordDataXContent(builder, params);
        builder.endObject();
    }

    public static ManualTriggerEvent parse(TriggerService triggerService, String watchId, String context, XContentParser parser) throws IOException {
        TriggerEvent parsedTriggerEvent = triggerService.parseTriggerEvent(watchId, context, parser);
        return new ManualTriggerEvent(context, parsedTriggerEvent);
    }
}

