/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.transport.actions.stats;

import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.watcher.WatcherBuild;
import org.elasticsearch.xpack.watcher.WatcherLifeCycleService;
import org.elasticsearch.xpack.watcher.WatcherService;
import org.elasticsearch.xpack.watcher.execution.ExecutionService;
import org.elasticsearch.xpack.watcher.transport.actions.WatcherTransportAction;
import org.elasticsearch.xpack.watcher.transport.actions.stats.WatcherStatsRequest;
import org.elasticsearch.xpack.watcher.transport.actions.stats.WatcherStatsResponse;

public class TransportWatcherStatsAction
extends WatcherTransportAction<WatcherStatsRequest, WatcherStatsResponse> {
    private final WatcherService watcherService;
    private final ExecutionService executionService;
    private final WatcherLifeCycleService lifeCycleService;

    @Inject
    public TransportWatcherStatsAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, WatcherService watcherService, ExecutionService executionService, XPackLicenseState licenseState, WatcherLifeCycleService lifeCycleService) {
        super(settings, "cluster:monitor/xpack/watcher/stats", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, licenseState, WatcherStatsRequest::new);
        this.watcherService = watcherService;
        this.executionService = executionService;
        this.lifeCycleService = lifeCycleService;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected WatcherStatsResponse newResponse() {
        return new WatcherStatsResponse();
    }

    @Override
    protected void masterOperation(WatcherStatsRequest request, ClusterState state, ActionListener<WatcherStatsResponse> listener) throws ElasticsearchException {
        WatcherStatsResponse statsResponse = new WatcherStatsResponse();
        statsResponse.setWatcherState(this.watcherService.state());
        statsResponse.setThreadPoolQueueSize(this.executionService.executionThreadPoolQueueSize());
        statsResponse.setWatchesCount(this.watcherService.watchesCount());
        statsResponse.setThreadPoolMaxSize(this.executionService.executionThreadPoolMaxSize());
        statsResponse.setBuild(WatcherBuild.CURRENT);
        statsResponse.setWatcherMetaData(this.lifeCycleService.watcherMetaData());
        if (request.includeCurrentWatches()) {
            statsResponse.setSnapshots(this.executionService.currentExecutions());
        }
        if (request.includeQueuedWatches()) {
            statsResponse.setQueuedWatches(this.executionService.queuedWatches());
        }
        listener.onResponse(statsResponse);
    }

    @Override
    protected ClusterBlockException checkBlock(WatcherStatsRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

