/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.transport.actions.service;

import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.watcher.WatcherLifeCycleService;
import org.elasticsearch.xpack.watcher.transport.actions.WatcherTransportAction;
import org.elasticsearch.xpack.watcher.transport.actions.service.WatcherServiceRequest;
import org.elasticsearch.xpack.watcher.transport.actions.service.WatcherServiceResponse;

public class TransportWatcherServiceAction
extends WatcherTransportAction<WatcherServiceRequest, WatcherServiceResponse> {
    private final WatcherLifeCycleService lifeCycleService;

    @Inject
    public TransportWatcherServiceAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, WatcherLifeCycleService lifeCycleService, XPackLicenseState licenseState) {
        super(settings, "cluster:admin/xpack/watcher/service", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, licenseState, WatcherServiceRequest::new);
        this.lifeCycleService = lifeCycleService;
    }

    @Override
    protected String executor() {
        return "management";
    }

    @Override
    protected WatcherServiceResponse newResponse() {
        return new WatcherServiceResponse();
    }

    @Override
    protected void masterOperation(WatcherServiceRequest request, ClusterState state, ActionListener<WatcherServiceResponse> listener) throws ElasticsearchException {
        switch (request.getCommand()) {
            case START: {
                this.lifeCycleService.start();
                break;
            }
            case STOP: {
                this.lifeCycleService.stop();
                break;
            }
            case RESTART: {
                this.lifeCycleService.stop();
                this.lifeCycleService.start();
                break;
            }
            default: {
                listener.onFailure(new IllegalArgumentException("Command [" + (Object)((Object)request.getCommand()) + "] is undefined"));
                return;
            }
        }
        listener.onResponse(new WatcherServiceResponse(true));
    }

    @Override
    protected ClusterBlockException checkBlock(WatcherServiceRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

