/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.transport.actions.put;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.xpack.watcher.client.WatchSourceBuilder;
import org.elasticsearch.xpack.watcher.support.validation.Validation;

public class PutWatchRequest
extends MasterNodeRequest<PutWatchRequest> {
    private static final TimeValue DEFAULT_TIMEOUT = TimeValue.timeValueSeconds(10L);
    private String id;
    private BytesReference source;
    private boolean active = true;
    private XContentType xContentType = XContentType.JSON;

    public PutWatchRequest() {
    }

    public PutWatchRequest(String id, WatchSourceBuilder source) {
        this(id, source.buildAsBytes(XContentType.JSON), XContentType.JSON);
    }

    @Deprecated
    public PutWatchRequest(String id, BytesReference source) {
        this(id, source, source != null ? XContentFactory.xContentType(source) : null);
    }

    public PutWatchRequest(String id, BytesReference source, XContentType xContentType) {
        this.id = id;
        this.source = source;
        this.xContentType = xContentType;
        this.masterNodeTimeout(DEFAULT_TIMEOUT);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public BytesReference getSource() {
        return this.source;
    }

    public void setSource(WatchSourceBuilder source) {
        this.setSource(source.buildAsBytes(XContentType.JSON), XContentType.JSON);
    }

    @Deprecated
    public void setSource(BytesReference source) {
        this.source = source;
        this.xContentType = XContentFactory.xContentType(source);
    }

    public void setSource(BytesReference source, XContentType xContentType) {
        this.source = source;
        this.xContentType = xContentType;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public XContentType xContentType() {
        return this.xContentType;
    }

    @Override
    public ActionRequestValidationException validate() {
        Validation.Error error;
        ActionRequestValidationException validationException = null;
        if (this.id == null) {
            validationException = ValidateActions.addValidationError("watch name is missing", validationException);
        }
        if ((error = Validation.watchId(this.id)) != null) {
            validationException = ValidateActions.addValidationError(error.message(), validationException);
        }
        if (this.source == null) {
            validationException = ValidateActions.addValidationError("watch source is missing", validationException);
        }
        return validationException;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.id = in.readString();
        this.source = in.readBytesReference();
        this.active = in.readBoolean();
        this.xContentType = in.getVersion().onOrAfter(Version.V_5_3_0_UNRELEASED) ? XContentType.readFrom(in) : XContentFactory.xContentType(this.source);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.id);
        out.writeBytesReference(this.source);
        out.writeBoolean(this.active);
        if (out.getVersion().onOrAfter(Version.V_5_3_0_UNRELEASED)) {
            this.xContentType.writeTo(out);
        }
    }
}

