/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.support.xcontent;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentLocation;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.xpack.common.secret.Secret;
import org.elasticsearch.xpack.security.crypto.CryptoService;
import org.elasticsearch.xpack.support.clock.Clock;
import org.elasticsearch.xpack.support.clock.SystemClock;

public class WatcherXContentParser
implements XContentParser {
    private final Clock clock;
    private final XContentParser parser;
    @Nullable
    private final CryptoService cryptoService;

    public static Secret secret(XContentParser parser) throws IOException {
        char[] chars = parser.text().toCharArray();
        if (parser instanceof WatcherXContentParser) {
            WatcherXContentParser watcherParser = (WatcherXContentParser)parser;
            if (watcherParser.cryptoService != null) {
                chars = watcherParser.cryptoService.encrypt(chars);
            }
        }
        return new Secret(chars);
    }

    public static Secret secretOrNull(XContentParser parser) throws IOException {
        String text = parser.textOrNull();
        if (text == null) {
            return null;
        }
        char[] chars = parser.text().toCharArray();
        if (parser instanceof WatcherXContentParser) {
            WatcherXContentParser watcherParser = (WatcherXContentParser)parser;
            if (watcherParser.cryptoService != null) {
                chars = watcherParser.cryptoService.encrypt(text.toCharArray());
            }
            return new Secret(chars);
        }
        return new Secret(chars);
    }

    public static Clock clock(XContentParser parser) {
        if (parser instanceof WatcherXContentParser) {
            return ((WatcherXContentParser)parser).clock;
        }
        return SystemClock.INSTANCE;
    }

    public WatcherXContentParser(XContentParser parser, Clock clock, @Nullable CryptoService cryptoService) {
        this.clock = clock;
        this.parser = parser;
        this.cryptoService = cryptoService;
    }

    @Override
    public XContentType contentType() {
        return this.parser.contentType();
    }

    @Override
    public XContentParser.Token nextToken() throws IOException {
        return this.parser.nextToken();
    }

    @Override
    public void skipChildren() throws IOException {
        this.parser.skipChildren();
    }

    @Override
    public XContentParser.Token currentToken() {
        return this.parser.currentToken();
    }

    @Override
    public String currentName() throws IOException {
        return this.parser.currentName();
    }

    @Override
    public Map<String, Object> map() throws IOException {
        return this.parser.map();
    }

    @Override
    public Map<String, Object> mapOrdered() throws IOException {
        return this.parser.mapOrdered();
    }

    @Override
    public Map<String, String> mapStrings() throws IOException {
        return this.parser.mapStrings();
    }

    @Override
    public Map<String, String> mapStringsOrdered() throws IOException {
        return this.parser.mapStringsOrdered();
    }

    @Override
    public List<Object> list() throws IOException {
        return this.parser.list();
    }

    @Override
    public List<Object> listOrderedMap() throws IOException {
        return this.parser.listOrderedMap();
    }

    @Override
    public String text() throws IOException {
        return this.parser.text();
    }

    @Override
    public String textOrNull() throws IOException {
        return this.parser.textOrNull();
    }

    @Override
    public BytesRef utf8BytesOrNull() throws IOException {
        return this.parser.utf8BytesOrNull();
    }

    @Override
    public BytesRef utf8Bytes() throws IOException {
        return this.parser.utf8Bytes();
    }

    @Override
    public Object objectText() throws IOException {
        return this.parser.objectText();
    }

    @Override
    public Object objectBytes() throws IOException {
        return this.parser.objectBytes();
    }

    @Override
    public boolean hasTextCharacters() {
        return this.parser.hasTextCharacters();
    }

    @Override
    public char[] textCharacters() throws IOException {
        return this.parser.textCharacters();
    }

    @Override
    public int textLength() throws IOException {
        return this.parser.textLength();
    }

    @Override
    public int textOffset() throws IOException {
        return this.parser.textOffset();
    }

    @Override
    public Number numberValue() throws IOException {
        return this.parser.numberValue();
    }

    @Override
    public XContentParser.NumberType numberType() throws IOException {
        return this.parser.numberType();
    }

    @Override
    public short shortValue(boolean coerce) throws IOException {
        return this.parser.shortValue(coerce);
    }

    @Override
    public int intValue(boolean coerce) throws IOException {
        return this.parser.intValue(coerce);
    }

    @Override
    public long longValue(boolean coerce) throws IOException {
        return this.parser.longValue(coerce);
    }

    @Override
    public float floatValue(boolean coerce) throws IOException {
        return this.parser.floatValue(coerce);
    }

    @Override
    public double doubleValue(boolean coerce) throws IOException {
        return this.parser.doubleValue(coerce);
    }

    @Override
    public short shortValue() throws IOException {
        return this.parser.shortValue();
    }

    @Override
    public int intValue() throws IOException {
        return this.parser.intValue();
    }

    @Override
    public long longValue() throws IOException {
        return this.parser.longValue();
    }

    @Override
    public float floatValue() throws IOException {
        return this.parser.floatValue();
    }

    @Override
    public double doubleValue() throws IOException {
        return this.parser.doubleValue();
    }

    @Override
    public boolean isBooleanValue() throws IOException {
        return this.parser.isBooleanValue();
    }

    @Override
    public boolean booleanValue() throws IOException {
        return this.parser.booleanValue();
    }

    @Override
    public byte[] binaryValue() throws IOException {
        return this.parser.binaryValue();
    }

    @Override
    public XContentLocation getTokenLocation() {
        return this.parser.getTokenLocation();
    }

    @Override
    public <T> T namedObject(Class<T> categoryClass, String name, Object context) throws IOException {
        return this.parser.namedObject(categoryClass, name, context);
    }

    @Override
    public NamedXContentRegistry getXContentRegistry() {
        return this.parser.getXContentRegistry();
    }

    @Override
    public boolean isClosed() {
        return this.parser.isClosed();
    }

    @Override
    public void close() throws ElasticsearchException {
        this.parser.close();
    }
}

