/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.input;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.multibindings.MapBinder;
import org.elasticsearch.xpack.watcher.input.InputFactory;
import org.elasticsearch.xpack.watcher.input.InputRegistry;
import org.elasticsearch.xpack.watcher.input.http.HttpInputFactory;
import org.elasticsearch.xpack.watcher.input.none.NoneInputFactory;
import org.elasticsearch.xpack.watcher.input.search.SearchInputFactory;
import org.elasticsearch.xpack.watcher.input.simple.SimpleInputFactory;

public class InputModule
extends AbstractModule {
    private final Map<String, Class<? extends InputFactory>> parsers = new HashMap<String, Class<? extends InputFactory>>();

    public void registerInput(String type, Class<? extends InputFactory> parserType) {
        this.parsers.put(type, parserType);
    }

    @Override
    protected void configure() {
        MapBinder<String, InputFactory> parsersBinder = MapBinder.newMapBinder(this.binder(), String.class, InputFactory.class);
        this.bind(SearchInputFactory.class).asEagerSingleton();
        parsersBinder.addBinding("search").to(SearchInputFactory.class);
        this.bind(SimpleInputFactory.class).asEagerSingleton();
        parsersBinder.addBinding("simple").to(SimpleInputFactory.class);
        this.bind(HttpInputFactory.class).asEagerSingleton();
        parsersBinder.addBinding("http").to(HttpInputFactory.class);
        this.bind(NoneInputFactory.class).asEagerSingleton();
        parsersBinder.addBinding("none").to(NoneInputFactory.class);
        for (Map.Entry<String, Class<? extends InputFactory>> entry : this.parsers.entrySet()) {
            this.bind(entry.getValue()).asEagerSingleton();
            parsersBinder.addBinding(entry.getKey()).to(entry.getValue());
        }
        this.bind(InputRegistry.class).asEagerSingleton();
    }
}

