/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.execution;

import java.util.UUID;
import org.elasticsearch.xpack.watcher.support.Exceptions;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class Wid {
    private static final DateTimeFormatter formatter = ISODateTimeFormat.dateTime();
    private final String watchId;
    private final String value;

    public Wid(String watchId, DateTime executionTime) {
        this.watchId = watchId;
        this.value = watchId + "_" + UUID.randomUUID().toString() + "-" + formatter.print(executionTime);
    }

    public Wid(String value) {
        this.value = value;
        int index = value.lastIndexOf("_");
        if (index <= 0) {
            throw Exceptions.illegalArgument("invalid watcher execution id [{}]", value);
        }
        this.watchId = value.substring(0, index);
    }

    public String value() {
        return this.value;
    }

    public String watchId() {
        return this.watchId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Wid wid = (Wid)o;
        return this.value.equals(wid.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.value;
    }
}

