/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.execution;

import java.util.Locale;
import org.elasticsearch.xpack.watcher.support.Exceptions;

public enum ActionExecutionMode {
    SIMULATE(1, false, true),
    FORCE_SIMULATE(2, true, true),
    EXECUTE(3, false, false),
    FORCE_EXECUTE(4, true, false),
    SKIP(5, false, false);

    private final byte id;
    private final boolean force;
    private final boolean simulate;

    private ActionExecutionMode(byte id, boolean froce, boolean simulate) {
        this.id = id;
        this.force = froce;
        this.simulate = simulate;
    }

    public final byte id() {
        return this.id;
    }

    public final boolean simulate() {
        return this.simulate;
    }

    public final boolean force() {
        return this.force;
    }

    public static ActionExecutionMode resolve(byte id) {
        switch (id) {
            case 1: {
                return SIMULATE;
            }
            case 2: {
                return FORCE_SIMULATE;
            }
            case 3: {
                return EXECUTE;
            }
            case 4: {
                return FORCE_EXECUTE;
            }
            case 5: {
                return SKIP;
            }
        }
        throw Exceptions.illegalArgument("unknown action execution mode id [{}]", id);
    }

    public static ActionExecutionMode resolve(String key) {
        if (key == null) {
            return null;
        }
        switch (key.toLowerCase(Locale.ROOT)) {
            case "simulate": {
                return SIMULATE;
            }
            case "force_simulate": {
                return FORCE_SIMULATE;
            }
            case "execute": {
                return EXECUTE;
            }
            case "force_execute": {
                return FORCE_EXECUTE;
            }
            case "skip": {
                return SKIP;
            }
        }
        throw Exceptions.illegalArgument("unknown action execution mode [{}]", key);
    }
}

