/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.transport.netty3;

import java.util.LinkedList;
import java.util.Queue;
import org.elasticsearch.jboss.netty.channel.ChannelFuture;
import org.elasticsearch.jboss.netty.channel.ChannelFutureListener;
import org.elasticsearch.jboss.netty.channel.ChannelHandlerContext;
import org.elasticsearch.jboss.netty.channel.ChannelStateEvent;
import org.elasticsearch.jboss.netty.channel.DownstreamMessageEvent;
import org.elasticsearch.jboss.netty.channel.MessageEvent;
import org.elasticsearch.jboss.netty.channel.SimpleChannelHandler;
import org.elasticsearch.jboss.netty.handler.ssl.SslHandler;
import org.elasticsearch.log4j.Logger;
import org.elasticsearch.log4j.message.ParameterizedMessage;

public class Netty3HandshakeWaitingHandler
extends SimpleChannelHandler {
    private final Logger logger;
    private boolean handshaken = false;
    private Queue<MessageEvent> pendingWrites = new LinkedList<MessageEvent>();

    public Netty3HandshakeWaitingHandler(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void channelConnected(final ChannelHandlerContext ctx, final ChannelStateEvent e) throws Exception {
        SslHandler sslHandler = ctx.getPipeline().get(SslHandler.class);
        final ChannelFuture handshakeFuture = sslHandler.handshake();
        handshakeFuture.addListener(new ChannelFutureListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void operationComplete(ChannelFuture channelFuture) throws Exception {
                if (handshakeFuture.isSuccess()) {
                    Netty3HandshakeWaitingHandler.this.logger.debug("SSL/TLS handshake completed for channel");
                    Netty3HandshakeWaitingHandler netty3HandshakeWaitingHandler = Netty3HandshakeWaitingHandler.this;
                    synchronized (netty3HandshakeWaitingHandler) {
                        Netty3HandshakeWaitingHandler.this.handshaken = true;
                        while (!Netty3HandshakeWaitingHandler.this.pendingWrites.isEmpty()) {
                            MessageEvent event = (MessageEvent)Netty3HandshakeWaitingHandler.this.pendingWrites.remove();
                            ctx.sendDownstream(event);
                        }
                        ctx.getPipeline().remove(Netty3HandshakeWaitingHandler.class);
                    }
                    ctx.sendUpstream(e);
                } else {
                    Throwable cause = handshakeFuture.getCause();
                    if (Netty3HandshakeWaitingHandler.this.logger.isDebugEnabled()) {
                        Netty3HandshakeWaitingHandler.this.logger.debug(() -> new ParameterizedMessage("SSL/TLS handshake failed, closing channel: {}", (Object)cause.getMessage()), cause);
                    } else {
                        Netty3HandshakeWaitingHandler.this.logger.error("SSL/TLS handshake failed, closing channel: {}", (Object)cause.getMessage());
                    }
                    Netty3HandshakeWaitingHandler netty3HandshakeWaitingHandler = Netty3HandshakeWaitingHandler.this;
                    synchronized (netty3HandshakeWaitingHandler) {
                        while (!Netty3HandshakeWaitingHandler.this.pendingWrites.isEmpty()) {
                            DownstreamMessageEvent event = (DownstreamMessageEvent)Netty3HandshakeWaitingHandler.this.pendingWrites.remove();
                            event.getFuture().setFailure(cause);
                        }
                        Netty3HandshakeWaitingHandler.this.pendingWrites = new SetFailureOnAddQueue(cause);
                        handshakeFuture.getChannel().close();
                    }
                }
            }
        });
    }

    @Override
    public synchronized void writeRequested(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        if (!this.handshaken) {
            this.pendingWrites.add(e);
            return;
        }
        ctx.sendDownstream(e);
    }

    synchronized boolean hasPendingWrites() {
        return !this.pendingWrites.isEmpty();
    }

    private static class SetFailureOnAddQueue
    extends LinkedList<MessageEvent> {
        private final Throwable cause;

        SetFailureOnAddQueue(Throwable cause) {
            this.cause = cause;
        }

        @Override
        public boolean add(MessageEvent messageEvent) {
            DownstreamMessageEvent event = (DownstreamMessageEvent)messageEvent;
            event.getFuture().setFailure(this.cause);
            return false;
        }
    }
}

