/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.role;

import java.io.IOException;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestActions;
import org.elasticsearch.xpack.security.action.role.ClearRolesCacheRequest;
import org.elasticsearch.xpack.security.action.role.ClearRolesCacheResponse;
import org.elasticsearch.xpack.security.client.SecurityClient;

public class RestClearRolesCacheAction
extends BaseRestHandler {
    public RestClearRolesCacheAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.POST, "/_xpack/security/role/{name}/_clear_cache", this);
        controller.registerAsDeprecatedHandler(RestRequest.Method.POST, "/_shield/role/{name}/_clear_cache", this, "[POST /_shield/role/{name}/_clear_cache] is deprecated! Use [POST /_xpack/security/role/{name}/_clear_cache] instead.", this.deprecationLogger);
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] roles = request.paramAsStringArrayOrEmptyIfAll("name");
        ClearRolesCacheRequest req = new ClearRolesCacheRequest().names(roles);
        return channel -> new SecurityClient(client).clearRolesCache(req, new RestActions.NodesResponseRestListener<ClearRolesCacheResponse>((RestChannel)channel));
    }
}

