/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.rest.RestRequest;

public class RemoteHostHeader {
    static final String KEY = "_rest_remote_address";

    public static void process(RestRequest request, ThreadContext threadContext) {
        threadContext.putTransient(KEY, request.getRemoteAddress());
    }

    public static InetSocketAddress restRemoteAddress(ThreadContext threadContext) {
        SocketAddress address = (SocketAddress)threadContext.getTransient(KEY);
        if (address != null && address instanceof InetSocketAddress) {
            return (InetSocketAddress)address;
        }
        return null;
    }

    public static void putRestRemoteAddress(ThreadContext threadContext, SocketAddress address) {
        threadContext.putTransient(KEY, address);
    }
}

