/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.privilege;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.apache.lucene.util.automaton.Automaton;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.xpack.security.authz.privilege.Privilege;
import org.elasticsearch.xpack.security.support.Automatons;

public final class IndexPrivilege
extends Privilege {
    private static final Automaton ALL_AUTOMATON = Automatons.patterns("indices:*");
    private static final Automaton READ_AUTOMATON = Automatons.patterns("indices:data/read/*");
    private static final Automaton CREATE_AUTOMATON = Automatons.patterns("indices:data/write/index*", "indices:data/write/bulk*", "indices:admin/mapping/put");
    private static final Automaton INDEX_AUTOMATON = Automatons.patterns("indices:data/write/index*", "indices:data/write/bulk*", "indices:data/write/update*", "indices:admin/mapping/put");
    private static final Automaton DELETE_AUTOMATON = Automatons.patterns("indices:data/write/delete*", "indices:data/write/bulk*");
    private static final Automaton WRITE_AUTOMATON = Automatons.patterns("indices:data/write/*", "indices:admin/mapping/put");
    private static final Automaton MONITOR_AUTOMATON = Automatons.patterns("indices:monitor/*");
    private static final Automaton MANAGE_AUTOMATON = Automatons.unionAndMinimize(Arrays.asList(MONITOR_AUTOMATON, Automatons.patterns("indices:admin/*")));
    private static final Automaton CREATE_INDEX_AUTOMATON = Automatons.patterns("indices:admin/create");
    private static final Automaton DELETE_INDEX_AUTOMATON = Automatons.patterns("indices:admin/delete");
    private static final Automaton VIEW_METADATA_AUTOMATON = Automatons.patterns("indices:admin/aliases/get", "indices:admin/aliases/exists", "indices:admin/get", "indices:admin/exists", "indices:admin/mappings/fields/get*", "indices:admin/mappings/get", "indices:admin/shards/search_shards", "indices:admin/types/exists", "indices:admin/validate/query*", "indices:monitor/settings/get");
    public static final IndexPrivilege NONE = new IndexPrivilege("none", Automatons.EMPTY);
    public static final IndexPrivilege ALL = new IndexPrivilege("all", ALL_AUTOMATON);
    public static final IndexPrivilege READ = new IndexPrivilege("read", READ_AUTOMATON);
    public static final IndexPrivilege CREATE = new IndexPrivilege("create", CREATE_AUTOMATON);
    public static final IndexPrivilege INDEX = new IndexPrivilege("index", INDEX_AUTOMATON);
    public static final IndexPrivilege DELETE = new IndexPrivilege("delete", DELETE_AUTOMATON);
    public static final IndexPrivilege WRITE = new IndexPrivilege("write", WRITE_AUTOMATON);
    public static final IndexPrivilege MONITOR = new IndexPrivilege("monitor", MONITOR_AUTOMATON);
    public static final IndexPrivilege MANAGE = new IndexPrivilege("manage", MANAGE_AUTOMATON);
    public static final IndexPrivilege DELETE_INDEX = new IndexPrivilege("delete_index", DELETE_INDEX_AUTOMATON);
    public static final IndexPrivilege CREATE_INDEX = new IndexPrivilege("create_index", CREATE_INDEX_AUTOMATON);
    public static final IndexPrivilege VIEW_METADATA = new IndexPrivilege("view_index_metadata", VIEW_METADATA_AUTOMATON);
    private static final Map<String, IndexPrivilege> VALUES = MapBuilder.newMapBuilder().put("none", NONE).put("all", ALL).put("manage", MANAGE).put("create_index", CREATE_INDEX).put("monitor", MONITOR).put("read", READ).put("index", INDEX).put("delete", DELETE).put("write", WRITE).put("create", CREATE).put("delete_index", DELETE_INDEX).put("view_index_metadata", VIEW_METADATA).immutableMap();
    public static final Predicate<String> ACTION_MATCHER = ALL.predicate();
    public static final Predicate<String> CREATE_INDEX_MATCHER = CREATE_INDEX.predicate();
    private static final ConcurrentHashMap<Set<String>, IndexPrivilege> CACHE = new ConcurrentHashMap();

    private IndexPrivilege(String name, Automaton automaton) {
        super(Collections.singleton(name), automaton);
    }

    private IndexPrivilege(Set<String> name, Automaton automaton) {
        super(name, automaton);
    }

    public static IndexPrivilege get(Set<String> name) {
        return CACHE.computeIfAbsent(name, theName -> {
            if (theName.isEmpty()) {
                return NONE;
            }
            return IndexPrivilege.resolve(theName);
        });
    }

    private static IndexPrivilege resolve(Set<String> name) {
        int size = name.size();
        if (size == 0) {
            throw new IllegalArgumentException("empty set should not be used");
        }
        HashSet<String> actions = new HashSet<String>();
        HashSet<Automaton> automata = new HashSet<Automaton>();
        for (String part : name) {
            if (ACTION_MATCHER.test(part = part.toLowerCase(Locale.ROOT))) {
                actions.add(IndexPrivilege.actionToPattern(part));
                continue;
            }
            IndexPrivilege indexPrivilege = VALUES.get(part);
            if (indexPrivilege != null && size == 1) {
                return indexPrivilege;
            }
            if (indexPrivilege != null) {
                automata.add(indexPrivilege.automaton);
                continue;
            }
            throw new IllegalArgumentException("unknown index privilege [" + name + "]. a privilege must be either one of the predefined fixed indices privileges [" + Strings.collectionToCommaDelimitedString(VALUES.entrySet()) + "] or a pattern over one of the available index actions");
        }
        if (!actions.isEmpty()) {
            automata.add(Automatons.patterns(actions));
        }
        return new IndexPrivilege(name, Automatons.unionAndMinimize(automata));
    }

    static Map<String, IndexPrivilege> values() {
        return VALUES;
    }
}

