/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.permission;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.apache.lucene.util.automaton.MinimizationOperations;
import org.apache.lucene.util.automaton.Operations;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.xpack.security.authz.accesscontrol.FieldSubsetReader;
import org.elasticsearch.xpack.security.authz.permission.FieldPermissionsDefinition;
import org.elasticsearch.xpack.security.support.Automatons;

public final class FieldPermissions
implements Accountable {
    public static final FieldPermissions DEFAULT = new FieldPermissions();
    private static final long BASE_FIELD_PERM_DEF_BYTES = RamUsageEstimator.shallowSizeOf(new FieldPermissionsDefinition(null, null));
    private static final long BASE_FIELD_GROUP_BYTES = RamUsageEstimator.shallowSizeOf(new FieldPermissionsDefinition.FieldGrantExcludeGroup(null, null));
    private static final long BASE_HASHSET_SIZE = RamUsageEstimator.shallowSizeOfInstance(HashSet.class);
    private static final long BASE_HASHSET_ENTRY_SIZE;
    private final FieldPermissionsDefinition fieldPermissionsDefinition;
    private final CharacterRunAutomaton permittedFieldsAutomaton;
    private final boolean permittedFieldsAutomatonIsTotal;
    private final Automaton originalAutomaton;
    private final long ramBytesUsed;

    public FieldPermissions() {
        this(new FieldPermissionsDefinition(null, null), Automatons.MATCH_ALL);
    }

    public FieldPermissions(FieldPermissionsDefinition fieldPermissionsDefinition) {
        this(fieldPermissionsDefinition, FieldPermissions.initializePermittedFieldsAutomaton(fieldPermissionsDefinition));
    }

    FieldPermissions(FieldPermissionsDefinition fieldPermissionsDefinition, Automaton permittedFieldsAutomaton) {
        if (!permittedFieldsAutomaton.isDeterministic() && permittedFieldsAutomaton.getNumStates() > 1) {
            throw new IllegalArgumentException("Only accepts deterministic automata");
        }
        this.fieldPermissionsDefinition = fieldPermissionsDefinition;
        this.originalAutomaton = permittedFieldsAutomaton;
        this.permittedFieldsAutomaton = new CharacterRunAutomaton(permittedFieldsAutomaton);
        this.permittedFieldsAutomatonIsTotal = Operations.isTotal(permittedFieldsAutomaton);
        long ramBytesUsed = BASE_FIELD_PERM_DEF_BYTES;
        for (FieldPermissionsDefinition.FieldGrantExcludeGroup group : fieldPermissionsDefinition.getFieldGrantExcludeGroups()) {
            ramBytesUsed += BASE_FIELD_GROUP_BYTES + BASE_HASHSET_ENTRY_SIZE;
            if (group.getGrantedFields() != null) {
                ramBytesUsed += RamUsageEstimator.shallowSizeOf(group.getGrantedFields());
            }
            if (group.getExcludedFields() == null) continue;
            ramBytesUsed += RamUsageEstimator.shallowSizeOf(group.getExcludedFields());
        }
        ramBytesUsed += permittedFieldsAutomaton.ramBytesUsed();
        this.ramBytesUsed = ramBytesUsed += FieldPermissions.runAutomatonRamBytesUsed(permittedFieldsAutomaton);
    }

    private static long runAutomatonRamBytesUsed(Automaton a) {
        return a.getNumStates() * 5;
    }

    static Automaton initializePermittedFieldsAutomaton(FieldPermissionsDefinition fieldPermissionsDefinition) {
        Set<FieldPermissionsDefinition.FieldGrantExcludeGroup> groups = fieldPermissionsDefinition.getFieldGrantExcludeGroups();
        assert (groups.size() > 0) : "there must always be a single group for field inclusion/exclusion";
        List<Automaton> automatonList = groups.stream().map(g -> FieldPermissions.initializePermittedFieldsAutomaton(g.getGrantedFields(), g.getExcludedFields())).collect(Collectors.toList());
        return Automatons.unionAndMinimize(automatonList);
    }

    private static Automaton initializePermittedFieldsAutomaton(String[] grantedFields, String[] deniedFields) {
        Automaton grantedFieldsAutomaton;
        if (grantedFields == null || Arrays.stream(grantedFields).anyMatch(Regex::isMatchAllPattern)) {
            grantedFieldsAutomaton = Automatons.MATCH_ALL;
        } else {
            Automaton metaFieldsAutomaton = Operations.concatenate(Automata.makeChar(95), Automata.makeAnyString());
            grantedFieldsAutomaton = Operations.union(Automatons.patterns(grantedFields), metaFieldsAutomaton);
        }
        Automaton deniedFieldsAutomaton = deniedFields == null || deniedFields.length == 0 ? Automatons.EMPTY : Automatons.patterns(deniedFields);
        grantedFieldsAutomaton = MinimizationOperations.minimize(grantedFieldsAutomaton, 10000);
        deniedFieldsAutomaton = MinimizationOperations.minimize(deniedFieldsAutomaton, 10000);
        if (!Operations.subsetOf(deniedFieldsAutomaton, grantedFieldsAutomaton)) {
            throw new ElasticsearchSecurityException("Exceptions for field permissions must be a subset of the granted fields but " + Strings.arrayToCommaDelimitedString(deniedFields) + " is not a subset of " + Strings.arrayToCommaDelimitedString(grantedFields), new Object[0]);
        }
        if (!(grantedFields != null && Arrays.binarySearch(grantedFields, "_all") >= 0 || deniedFields != null && Arrays.binarySearch(deniedFields, "_all") >= 0 || Operations.isTotal(grantedFieldsAutomaton) && Operations.isEmpty(deniedFieldsAutomaton))) {
            deniedFieldsAutomaton = Operations.union(deniedFieldsAutomaton, Automata.makeString("_all"));
        }
        grantedFieldsAutomaton = Automatons.minusAndMinimize(grantedFieldsAutomaton, deniedFieldsAutomaton);
        return grantedFieldsAutomaton;
    }

    public boolean grantsAccessTo(String fieldName) {
        return this.permittedFieldsAutomatonIsTotal || this.permittedFieldsAutomaton.run(fieldName);
    }

    FieldPermissionsDefinition getFieldPermissionsDefinition() {
        return this.fieldPermissionsDefinition;
    }

    public boolean hasFieldLevelSecurity() {
        return !this.permittedFieldsAutomatonIsTotal;
    }

    public DirectoryReader filter(DirectoryReader reader) throws IOException {
        if (!this.hasFieldLevelSecurity()) {
            return reader;
        }
        return FieldSubsetReader.wrap(reader, this.permittedFieldsAutomaton);
    }

    Automaton getIncludeAutomaton() {
        return this.originalAutomaton;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldPermissions that = (FieldPermissions)o;
        if (this.permittedFieldsAutomatonIsTotal != that.permittedFieldsAutomatonIsTotal) {
            return false;
        }
        return this.fieldPermissionsDefinition != null ? this.fieldPermissionsDefinition.equals(that.fieldPermissionsDefinition) : that.fieldPermissionsDefinition == null;
    }

    public int hashCode() {
        int result = this.fieldPermissionsDefinition != null ? this.fieldPermissionsDefinition.hashCode() : 0;
        result = 31 * result + (this.permittedFieldsAutomatonIsTotal ? 1 : 0);
        return result;
    }

    @Override
    public long ramBytesUsed() {
        return this.ramBytesUsed;
    }

    static {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(FieldPermissions.class.getName(), new Object());
        long mapEntryShallowSize = RamUsageEstimator.shallowSizeOf(map.entrySet().iterator().next());
        BASE_HASHSET_ENTRY_SIZE = mapEntryShallowSize + (long)(2 * RamUsageEstimator.NUM_BYTES_OBJECT_REF);
    }
}

