/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.accesscontrol;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FilterIterator;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;

public final class FieldSubsetReader
extends FilterLeafReader {
    private final FieldInfos fieldInfos;
    private final CharacterRunAutomaton filter;

    public static DirectoryReader wrap(DirectoryReader in, CharacterRunAutomaton filter) throws IOException {
        return new FieldSubsetDirectoryReader(in, filter);
    }

    FieldSubsetReader(LeafReader in, CharacterRunAutomaton filter) {
        super(in);
        ArrayList<FieldInfo> filteredInfos = new ArrayList<FieldInfo>();
        for (FieldInfo fi : in.getFieldInfos()) {
            if (!filter.run(fi.name)) continue;
            filteredInfos.add(fi);
        }
        this.fieldInfos = new FieldInfos(filteredInfos.toArray(new FieldInfo[filteredInfos.size()]));
        this.filter = filter;
    }

    boolean hasField(String field) {
        return this.fieldInfos.fieldInfo(field) != null;
    }

    @Override
    public FieldInfos getFieldInfos() {
        return this.fieldInfos;
    }

    @Override
    public Fields getTermVectors(int docID) throws IOException {
        Fields f = super.getTermVectors(docID);
        if (f == null) {
            return null;
        }
        return (f = new FieldFilterFields(f)).iterator().hasNext() ? f : null;
    }

    static Map<String, Object> filter(Map<String, ?> map, CharacterRunAutomaton includeAutomaton, int initialState) {
        HashMap<String, Object> filtered = new HashMap<String, Object>();
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            List<Object> filteredValue;
            String key = entry.getKey();
            int state = FieldSubsetReader.step(includeAutomaton, key, initialState);
            if (state == -1) continue;
            Object value = entry.getValue();
            if (value instanceof Map) {
                Map mapValue;
                if ((state = includeAutomaton.step(state, 46)) == -1 || (filteredValue = FieldSubsetReader.filter(mapValue = (Map)value, includeAutomaton, state)).isEmpty()) continue;
                filtered.put(key, filteredValue);
                continue;
            }
            if (value instanceof Iterable) {
                Iterable iterableValue = (Iterable)value;
                filteredValue = FieldSubsetReader.filter(iterableValue, includeAutomaton, state);
                if (filteredValue.isEmpty()) continue;
                filtered.put(key, filteredValue);
                continue;
            }
            if (!includeAutomaton.isAccept(state)) continue;
            filtered.put(key, value);
        }
        return filtered;
    }

    private static List<Object> filter(Iterable<?> iterable, CharacterRunAutomaton includeAutomaton, int initialState) {
        ArrayList<Object> filtered = new ArrayList<Object>();
        for (Object value : iterable) {
            if (value instanceof Map) {
                Map<String, Object> filteredValue;
                int state = includeAutomaton.step(initialState, 46);
                if (state == -1 || (filteredValue = FieldSubsetReader.filter((Map)value, includeAutomaton, state)).isEmpty()) continue;
                filtered.add(filteredValue);
                continue;
            }
            if (value instanceof Iterable) {
                List<Object> filteredValue = FieldSubsetReader.filter((Iterable)value, includeAutomaton, initialState);
                if (filteredValue.isEmpty()) continue;
                filtered.add(filteredValue);
                continue;
            }
            if (!includeAutomaton.isAccept(initialState)) continue;
            filtered.add(value);
        }
        return filtered;
    }

    private static int step(CharacterRunAutomaton automaton, String key, int state) {
        for (int i = 0; state != -1 && i < key.length(); ++i) {
            state = automaton.step(state, key.charAt(i));
        }
        return state;
    }

    @Override
    public void document(int docID, final StoredFieldVisitor visitor) throws IOException {
        super.document(docID, new StoredFieldVisitor(){

            @Override
            public void binaryField(FieldInfo fieldInfo, byte[] value) throws IOException {
                if ("_source".equals(fieldInfo.name)) {
                    BytesArray bytes = new BytesArray(value);
                    Tuple<XContentType, Map<String, Object>> result = XContentHelper.convertToMap(bytes, true);
                    Map<String, Object> transformedSource = FieldSubsetReader.filter(result.v2(), FieldSubsetReader.this.filter, 0);
                    XContentBuilder xContentBuilder = XContentBuilder.builder(result.v1().xContent()).map(transformedSource);
                    visitor.binaryField(fieldInfo, BytesReference.toBytes(xContentBuilder.bytes()));
                } else {
                    visitor.binaryField(fieldInfo, value);
                }
            }

            @Override
            public void stringField(FieldInfo fieldInfo, byte[] value) throws IOException {
                visitor.stringField(fieldInfo, value);
            }

            @Override
            public void intField(FieldInfo fieldInfo, int value) throws IOException {
                visitor.intField(fieldInfo, value);
            }

            @Override
            public void longField(FieldInfo fieldInfo, long value) throws IOException {
                visitor.longField(fieldInfo, value);
            }

            @Override
            public void floatField(FieldInfo fieldInfo, float value) throws IOException {
                visitor.floatField(fieldInfo, value);
            }

            @Override
            public void doubleField(FieldInfo fieldInfo, double value) throws IOException {
                visitor.doubleField(fieldInfo, value);
            }

            @Override
            public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
                return FieldSubsetReader.this.hasField(fieldInfo.name) ? visitor.needsField(fieldInfo) : StoredFieldVisitor.Status.NO;
            }
        });
    }

    @Override
    public Fields fields() throws IOException {
        return new FieldFilterFields(super.fields());
    }

    @Override
    public NumericDocValues getNumericDocValues(String field) throws IOException {
        return this.hasField(field) ? super.getNumericDocValues(field) : null;
    }

    @Override
    public BinaryDocValues getBinaryDocValues(String field) throws IOException {
        return this.hasField(field) ? super.getBinaryDocValues(field) : null;
    }

    @Override
    public SortedDocValues getSortedDocValues(String field) throws IOException {
        return this.hasField(field) ? super.getSortedDocValues(field) : null;
    }

    @Override
    public SortedNumericDocValues getSortedNumericDocValues(String field) throws IOException {
        return this.hasField(field) ? super.getSortedNumericDocValues(field) : null;
    }

    @Override
    public SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
        return this.hasField(field) ? super.getSortedSetDocValues(field) : null;
    }

    @Override
    public NumericDocValues getNormValues(String field) throws IOException {
        return this.hasField(field) ? super.getNormValues(field) : null;
    }

    @Override
    public Bits getDocsWithField(String field) throws IOException {
        return this.hasField(field) ? super.getDocsWithField(field) : null;
    }

    @Override
    public Object getCoreCacheKey() {
        return this.in.getCoreCacheKey();
    }

    @Override
    public PointValues getPointValues() {
        PointValues points = super.getPointValues();
        if (points == null) {
            return null;
        }
        return new FieldFilterPointValues(points);
    }

    final class FieldFilterPointValues
    extends PointValues {
        private final PointValues in;

        FieldFilterPointValues(PointValues in) {
            this.in = in;
        }

        @Override
        public void intersect(String fieldName, PointValues.IntersectVisitor visitor) throws IOException {
            if (!FieldSubsetReader.this.hasField(fieldName)) {
                return;
            }
            this.in.intersect(fieldName, visitor);
        }

        @Override
        public byte[] getMinPackedValue(String fieldName) throws IOException {
            if (FieldSubsetReader.this.hasField(fieldName)) {
                return this.in.getMinPackedValue(fieldName);
            }
            return null;
        }

        @Override
        public byte[] getMaxPackedValue(String fieldName) throws IOException {
            if (FieldSubsetReader.this.hasField(fieldName)) {
                return this.in.getMaxPackedValue(fieldName);
            }
            return null;
        }

        @Override
        public int getNumDimensions(String fieldName) throws IOException {
            if (FieldSubsetReader.this.hasField(fieldName)) {
                return this.in.getNumDimensions(fieldName);
            }
            return 0;
        }

        @Override
        public int getBytesPerDimension(String fieldName) throws IOException {
            if (FieldSubsetReader.this.hasField(fieldName)) {
                return this.in.getBytesPerDimension(fieldName);
            }
            return 0;
        }

        @Override
        public long size(String fieldName) {
            if (FieldSubsetReader.this.hasField(fieldName)) {
                return this.in.size(fieldName);
            }
            return 0L;
        }

        @Override
        public int getDocCount(String fieldName) {
            if (FieldSubsetReader.this.hasField(fieldName)) {
                return this.in.getDocCount(fieldName);
            }
            return 0;
        }
    }

    class FieldNamesTermsEnum
    extends FilterLeafReader.FilterTermsEnum {
        FieldNamesTermsEnum(TermsEnum in) {
            super(in);
        }

        boolean accept(BytesRef term) {
            return FieldSubsetReader.this.hasField(term.utf8ToString());
        }

        @Override
        public boolean seekExact(BytesRef term) throws IOException {
            return this.accept(term) && this.in.seekExact(term);
        }

        @Override
        public TermsEnum.SeekStatus seekCeil(BytesRef term) throws IOException {
            TermsEnum.SeekStatus status = this.in.seekCeil(term);
            if (status == TermsEnum.SeekStatus.END || this.accept(this.term())) {
                return status;
            }
            return this.next() == null ? TermsEnum.SeekStatus.END : TermsEnum.SeekStatus.NOT_FOUND;
        }

        @Override
        public BytesRef next() throws IOException {
            BytesRef next;
            while ((next = this.in.next()) != null && !this.accept(next)) {
            }
            return next;
        }

        @Override
        public void seekExact(long ord) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long ord() throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    class FieldNamesTerms
    extends FilterLeafReader.FilterTerms {
        FieldNamesTerms(Terms in) {
            super(in);
        }

        @Override
        public TermsEnum iterator() throws IOException {
            return new FieldNamesTermsEnum(this.in.iterator());
        }

        @Override
        public int getDocCount() throws IOException {
            return -1;
        }

        @Override
        public long getSumDocFreq() throws IOException {
            return -1L;
        }

        @Override
        public long getSumTotalTermFreq() throws IOException {
            return -1L;
        }

        @Override
        public long size() throws IOException {
            return -1L;
        }
    }

    class FieldFilterFields
    extends FilterLeafReader.FilterFields {
        FieldFilterFields(Fields in) {
            super(in);
        }

        @Override
        public int size() {
            return -1;
        }

        @Override
        public Iterator<String> iterator() {
            return new FilterIterator<String, String>(super.iterator()){

                @Override
                protected boolean predicateFunction(String field) {
                    return FieldSubsetReader.this.hasField(field);
                }
            };
        }

        @Override
        public Terms terms(String field) throws IOException {
            if (!FieldSubsetReader.this.hasField(field)) {
                return null;
            }
            if ("_field_names".equals(field)) {
                Terms terms = super.terms(field);
                if (terms != null) {
                    terms = new FieldNamesTerms(terms);
                }
                return terms;
            }
            return super.terms(field);
        }
    }

    static class FieldSubsetDirectoryReader
    extends FilterDirectoryReader {
        private final CharacterRunAutomaton filter;

        FieldSubsetDirectoryReader(DirectoryReader in, final CharacterRunAutomaton filter) throws IOException {
            super(in, new FilterDirectoryReader.SubReaderWrapper(){

                @Override
                public LeafReader wrap(LeafReader reader) {
                    return new FieldSubsetReader(reader, filter);
                }
            });
            this.filter = filter;
            FieldSubsetDirectoryReader.verifyNoOtherFieldSubsetDirectoryReaderIsWrapped(in);
        }

        @Override
        protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) throws IOException {
            return new FieldSubsetDirectoryReader(in, this.filter);
        }

        CharacterRunAutomaton getFilter() {
            return this.filter;
        }

        private static void verifyNoOtherFieldSubsetDirectoryReaderIsWrapped(DirectoryReader reader) {
            if (reader instanceof FilterDirectoryReader) {
                FilterDirectoryReader filterDirectoryReader = (FilterDirectoryReader)reader;
                if (filterDirectoryReader instanceof FieldSubsetDirectoryReader) {
                    throw new IllegalArgumentException(LoggerMessageFormat.format("Can't wrap [{}] twice", FieldSubsetDirectoryReader.class));
                }
                FieldSubsetDirectoryReader.verifyNoOtherFieldSubsetDirectoryReaderIsWrapped(filterDirectoryReader.getDelegate());
            }
        }

        @Override
        public Object getCoreCacheKey() {
            return this.in.getCoreCacheKey();
        }
    }
}

